//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#include <ndis.h>
#include <ntddndis.h>

#ifdef NATIVE_WIFI
#include <windot11.h>
#endif

typedef struct _OID_TABLE
{
    NDIS_OID Oid;
    WCHAR* szOid;
} OID_TABLE, *POID_TABLE;

OID_TABLE g_OidTable[] =
{
   // look for files in \macallan\public\common\ddk\inc and .
   // ntddndis.h
   // 602 Oids found
   { OID_GEN_SUPPORTED_LIST,        L"OID_GEN_SUPPORTED_LIST" },
   { OID_GEN_HARDWARE_STATUS,       L"OID_GEN_HARDWARE_STATUS" },
   { OID_GEN_MEDIA_SUPPORTED,       L"OID_GEN_MEDIA_SUPPORTED" },
   { OID_GEN_MEDIA_IN_USE,          L"OID_GEN_MEDIA_IN_USE" },
   { OID_GEN_MAXIMUM_LOOKAHEAD,     L"OID_GEN_MAXIMUM_LOOKAHEAD" },
   { OID_GEN_MAXIMUM_FRAME_SIZE,    L"OID_GEN_MAXIMUM_FRAME_SIZE" },
   { OID_GEN_LINK_SPEED,            L"OID_GEN_LINK_SPEED" },
   { OID_GEN_TRANSMIT_BUFFER_SPACE, L"OID_GEN_TRANSMIT_BUFFER_SPACE" },
   { OID_GEN_RECEIVE_BUFFER_SPACE,  L"OID_GEN_RECEIVE_BUFFER_SPACE" },
   { OID_GEN_TRANSMIT_BLOCK_SIZE,   L"OID_GEN_TRANSMIT_BLOCK_SIZE" },
   { OID_GEN_RECEIVE_BLOCK_SIZE,    L"OID_GEN_RECEIVE_BLOCK_SIZE" },
   { OID_GEN_VENDOR_ID,             L"OID_GEN_VENDOR_ID" },
   { OID_GEN_VENDOR_DESCRIPTION,    L"OID_GEN_VENDOR_DESCRIPTION" },
   { OID_GEN_CURRENT_PACKET_FILTER, L"OID_GEN_CURRENT_PACKET_FILTER" },
   { OID_GEN_CURRENT_LOOKAHEAD,     L"OID_GEN_CURRENT_LOOKAHEAD" },
   { OID_GEN_DRIVER_VERSION,        L"OID_GEN_DRIVER_VERSION" },
   { OID_GEN_MAXIMUM_TOTAL_SIZE,    L"OID_GEN_MAXIMUM_TOTAL_SIZE" },
   { OID_GEN_PROTOCOL_OPTIONS,      L"OID_GEN_PROTOCOL_OPTIONS" },
   { OID_GEN_MAC_OPTIONS,           L"OID_GEN_MAC_OPTIONS" },
   { OID_GEN_MEDIA_CONNECT_STATUS,  L"OID_GEN_MEDIA_CONNECT_STATUS" },
   { OID_GEN_MAXIMUM_SEND_PACKETS,  L"OID_GEN_MAXIMUM_SEND_PACKETS" },
   { OID_GEN_VENDOR_DRIVER_VERSION, L"OID_GEN_VENDOR_DRIVER_VERSION" },
   { OID_GEN_SUPPORTED_GUIDS,       L"OID_GEN_SUPPORTED_GUIDS" },
   { OID_GEN_NETWORK_LAYER_ADDRESSES,   L"OID_GEN_NETWORK_LAYER_ADDRESSES" },
   { OID_GEN_TRANSPORT_HEADER_OFFSET,   L"OID_GEN_TRANSPORT_HEADER_OFFSET" },
   { OID_GEN_MACHINE_NAME,          L"OID_GEN_MACHINE_NAME" },
   { OID_GEN_RNDIS_CONFIG_PARAMETER,   L"OID_GEN_RNDIS_CONFIG_PARAMETER" },
   { OID_GEN_VLAN_ID,               L"OID_GEN_VLAN_ID" },
   { OID_GEN_MEDIA_CAPABILITIES,    L"OID_GEN_MEDIA_CAPABILITIES" },
   { OID_GEN_PHYSICAL_MEDIUM,       L"OID_GEN_PHYSICAL_MEDIUM" },
   { OID_GEN_XMIT_OK,               L"OID_GEN_XMIT_OK" },
   { OID_GEN_RCV_OK,                L"OID_GEN_RCV_OK" },
   { OID_GEN_XMIT_ERROR,            L"OID_GEN_XMIT_ERROR" },
   { OID_GEN_RCV_ERROR,             L"OID_GEN_RCV_ERROR" },
   { OID_GEN_RCV_NO_BUFFER,         L"OID_GEN_RCV_NO_BUFFER" },
   { OID_GEN_DIRECTED_BYTES_XMIT,   L"OID_GEN_DIRECTED_BYTES_XMIT" },
   { OID_GEN_DIRECTED_FRAMES_XMIT,  L"OID_GEN_DIRECTED_FRAMES_XMIT" },
   { OID_GEN_MULTICAST_BYTES_XMIT,  L"OID_GEN_MULTICAST_BYTES_XMIT" },
   { OID_GEN_MULTICAST_FRAMES_XMIT, L"OID_GEN_MULTICAST_FRAMES_XMIT" },
   { OID_GEN_BROADCAST_BYTES_XMIT,  L"OID_GEN_BROADCAST_BYTES_XMIT" },
   { OID_GEN_BROADCAST_FRAMES_XMIT, L"OID_GEN_BROADCAST_FRAMES_XMIT" },
   { OID_GEN_DIRECTED_BYTES_RCV,    L"OID_GEN_DIRECTED_BYTES_RCV" },
   { OID_GEN_DIRECTED_FRAMES_RCV,   L"OID_GEN_DIRECTED_FRAMES_RCV" },
   { OID_GEN_MULTICAST_BYTES_RCV,   L"OID_GEN_MULTICAST_BYTES_RCV" },
   { OID_GEN_MULTICAST_FRAMES_RCV,  L"OID_GEN_MULTICAST_FRAMES_RCV" },
   { OID_GEN_BROADCAST_BYTES_RCV,   L"OID_GEN_BROADCAST_BYTES_RCV" },
   { OID_GEN_BROADCAST_FRAMES_RCV,  L"OID_GEN_BROADCAST_FRAMES_RCV" },
   { OID_GEN_RCV_CRC_ERROR,         L"OID_GEN_RCV_CRC_ERROR" },
   { OID_GEN_TRANSMIT_QUEUE_LENGTH, L"OID_GEN_TRANSMIT_QUEUE_LENGTH" },
   { OID_GEN_GET_TIME_CAPS,         L"OID_GEN_GET_TIME_CAPS" },
   { OID_GEN_GET_NETCARD_TIME,      L"OID_GEN_GET_NETCARD_TIME" },
   { OID_GEN_NETCARD_LOAD,          L"OID_GEN_NETCARD_LOAD" },
   { OID_GEN_DEVICE_PROFILE,        L"OID_GEN_DEVICE_PROFILE" },
   { OID_GEN_INIT_TIME_MS,          L"OID_GEN_INIT_TIME_MS" },
   { OID_GEN_RESET_COUNTS,          L"OID_GEN_RESET_COUNTS" },
   { OID_GEN_MEDIA_SENSE_COUNTS,    L"OID_GEN_MEDIA_SENSE_COUNTS" },
   { OID_GEN_FRIENDLY_NAME,         L"OID_GEN_FRIENDLY_NAME" },
   { OID_GEN_MINIPORT_INFO,         L"OID_GEN_MINIPORT_INFO" },
   { OID_GEN_RESET_VERIFY_PARAMETERS,   L"OID_GEN_RESET_VERIFY_PARAMETERS" },
   { OID_GEN_CO_SUPPORTED_LIST,     L"OID_GEN_CO_SUPPORTED_LIST" },
   { OID_GEN_CO_HARDWARE_STATUS,    L"OID_GEN_CO_HARDWARE_STATUS" },
   { OID_GEN_CO_MEDIA_SUPPORTED,    L"OID_GEN_CO_MEDIA_SUPPORTED" },
   { OID_GEN_CO_MEDIA_IN_USE,       L"OID_GEN_CO_MEDIA_IN_USE" },
   { OID_GEN_CO_LINK_SPEED,         L"OID_GEN_CO_LINK_SPEED" },
   { OID_GEN_CO_VENDOR_ID,          L"OID_GEN_CO_VENDOR_ID" },
   { OID_GEN_CO_VENDOR_DESCRIPTION, L"OID_GEN_CO_VENDOR_DESCRIPTION" },
   { OID_GEN_CO_DRIVER_VERSION,     L"OID_GEN_CO_DRIVER_VERSION" },
   { OID_GEN_CO_PROTOCOL_OPTIONS,   L"OID_GEN_CO_PROTOCOL_OPTIONS" },
   { OID_GEN_CO_MAC_OPTIONS,        L"OID_GEN_CO_MAC_OPTIONS" },
   { OID_GEN_CO_MEDIA_CONNECT_STATUS,   L"OID_GEN_CO_MEDIA_CONNECT_STATUS" },
   { OID_GEN_CO_VENDOR_DRIVER_VERSION,   L"OID_GEN_CO_VENDOR_DRIVER_VERSION" },
   { OID_GEN_CO_SUPPORTED_GUIDS,    L"OID_GEN_CO_SUPPORTED_GUIDS" },
   { OID_GEN_CO_GET_TIME_CAPS,      L"OID_GEN_CO_GET_TIME_CAPS" },
   { OID_GEN_CO_GET_NETCARD_TIME,   L"OID_GEN_CO_GET_NETCARD_TIME" },
   { OID_GEN_CO_MINIMUM_LINK_SPEED, L"OID_GEN_CO_MINIMUM_LINK_SPEED" },
   { OID_GEN_CO_XMIT_PDUS_OK,       L"OID_GEN_CO_XMIT_PDUS_OK" },
   { OID_GEN_CO_RCV_PDUS_OK,        L"OID_GEN_CO_RCV_PDUS_OK" },
   { OID_GEN_CO_XMIT_PDUS_ERROR,    L"OID_GEN_CO_XMIT_PDUS_ERROR" },
   { OID_GEN_CO_RCV_PDUS_ERROR,     L"OID_GEN_CO_RCV_PDUS_ERROR" },
   { OID_GEN_CO_RCV_PDUS_NO_BUFFER, L"OID_GEN_CO_RCV_PDUS_NO_BUFFER" },
   { OID_GEN_CO_RCV_CRC_ERROR,      L"OID_GEN_CO_RCV_CRC_ERROR" },
   { OID_GEN_CO_TRANSMIT_QUEUE_LENGTH,   L"OID_GEN_CO_TRANSMIT_QUEUE_LENGTH" },
   { OID_GEN_CO_BYTES_XMIT,         L"OID_GEN_CO_BYTES_XMIT" },
   { OID_GEN_CO_BYTES_RCV,          L"OID_GEN_CO_BYTES_RCV" },
   { OID_GEN_CO_NETCARD_LOAD,       L"OID_GEN_CO_NETCARD_LOAD" },
   { OID_GEN_CO_DEVICE_PROFILE,     L"OID_GEN_CO_DEVICE_PROFILE" },
   { OID_GEN_CO_BYTES_XMIT_OUTSTANDING,   L"OID_GEN_CO_BYTES_XMIT_OUTSTANDING" },
   { OID_802_3_PERMANENT_ADDRESS,   L"OID_802_3_PERMANENT_ADDRESS" },
   { OID_802_3_CURRENT_ADDRESS,     L"OID_802_3_CURRENT_ADDRESS" },
   { OID_802_3_MULTICAST_LIST,      L"OID_802_3_MULTICAST_LIST" },
   { OID_802_3_MAXIMUM_LIST_SIZE,   L"OID_802_3_MAXIMUM_LIST_SIZE" },
   { OID_802_3_MAC_OPTIONS,         L"OID_802_3_MAC_OPTIONS" },
   { OID_802_3_RCV_ERROR_ALIGNMENT, L"OID_802_3_RCV_ERROR_ALIGNMENT" },
   { OID_802_3_XMIT_ONE_COLLISION,  L"OID_802_3_XMIT_ONE_COLLISION" },
   { OID_802_3_XMIT_MORE_COLLISIONS,   L"OID_802_3_XMIT_MORE_COLLISIONS" },
   { OID_802_3_XMIT_DEFERRED,       L"OID_802_3_XMIT_DEFERRED" },
   { OID_802_3_XMIT_MAX_COLLISIONS, L"OID_802_3_XMIT_MAX_COLLISIONS" },
   { OID_802_3_RCV_OVERRUN,         L"OID_802_3_RCV_OVERRUN" },
   { OID_802_3_XMIT_UNDERRUN,       L"OID_802_3_XMIT_UNDERRUN" },
   { OID_802_3_XMIT_HEARTBEAT_FAILURE,   L"OID_802_3_XMIT_HEARTBEAT_FAILURE" },
   { OID_802_3_XMIT_TIMES_CRS_LOST, L"OID_802_3_XMIT_TIMES_CRS_LOST" },
   { OID_802_3_XMIT_LATE_COLLISIONS,   L"OID_802_3_XMIT_LATE_COLLISIONS" },
   { OID_802_5_PERMANENT_ADDRESS,   L"OID_802_5_PERMANENT_ADDRESS" },
   { OID_802_5_CURRENT_ADDRESS,     L"OID_802_5_CURRENT_ADDRESS" },
   { OID_802_5_CURRENT_FUNCTIONAL,  L"OID_802_5_CURRENT_FUNCTIONAL" },
   { OID_802_5_CURRENT_GROUP,       L"OID_802_5_CURRENT_GROUP" },
   { OID_802_5_LAST_OPEN_STATUS,    L"OID_802_5_LAST_OPEN_STATUS" },
   { OID_802_5_CURRENT_RING_STATUS, L"OID_802_5_CURRENT_RING_STATUS" },
   { OID_802_5_CURRENT_RING_STATE,  L"OID_802_5_CURRENT_RING_STATE" },
   { OID_802_5_LINE_ERRORS,         L"OID_802_5_LINE_ERRORS" },
   { OID_802_5_LOST_FRAMES,         L"OID_802_5_LOST_FRAMES" },
   { OID_802_5_BURST_ERRORS,        L"OID_802_5_BURST_ERRORS" },
   { OID_802_5_AC_ERRORS,           L"OID_802_5_AC_ERRORS" },
   { OID_802_5_ABORT_DELIMETERS,    L"OID_802_5_ABORT_DELIMETERS" },
   { OID_802_5_FRAME_COPIED_ERRORS, L"OID_802_5_FRAME_COPIED_ERRORS" },
   { OID_802_5_FREQUENCY_ERRORS,    L"OID_802_5_FREQUENCY_ERRORS" },
   { OID_802_5_TOKEN_ERRORS,        L"OID_802_5_TOKEN_ERRORS" },
   { OID_802_5_INTERNAL_ERRORS,     L"OID_802_5_INTERNAL_ERRORS" },
   { OID_FDDI_LONG_PERMANENT_ADDR,  L"OID_FDDI_LONG_PERMANENT_ADDR" },
   { OID_FDDI_LONG_CURRENT_ADDR,    L"OID_FDDI_LONG_CURRENT_ADDR" },
   { OID_FDDI_LONG_MULTICAST_LIST,  L"OID_FDDI_LONG_MULTICAST_LIST" },
   { OID_FDDI_LONG_MAX_LIST_SIZE,   L"OID_FDDI_LONG_MAX_LIST_SIZE" },
   { OID_FDDI_SHORT_PERMANENT_ADDR, L"OID_FDDI_SHORT_PERMANENT_ADDR" },
   { OID_FDDI_SHORT_CURRENT_ADDR,   L"OID_FDDI_SHORT_CURRENT_ADDR" },
   { OID_FDDI_SHORT_MULTICAST_LIST, L"OID_FDDI_SHORT_MULTICAST_LIST" },
   { OID_FDDI_SHORT_MAX_LIST_SIZE,  L"OID_FDDI_SHORT_MAX_LIST_SIZE" },
   { OID_FDDI_ATTACHMENT_TYPE,      L"OID_FDDI_ATTACHMENT_TYPE" },
   { OID_FDDI_UPSTREAM_NODE_LONG,   L"OID_FDDI_UPSTREAM_NODE_LONG" },
   { OID_FDDI_DOWNSTREAM_NODE_LONG, L"OID_FDDI_DOWNSTREAM_NODE_LONG" },
   { OID_FDDI_FRAME_ERRORS,         L"OID_FDDI_FRAME_ERRORS" },
   { OID_FDDI_FRAMES_LOST,          L"OID_FDDI_FRAMES_LOST" },
   { OID_FDDI_RING_MGT_STATE,       L"OID_FDDI_RING_MGT_STATE" },
   { OID_FDDI_LCT_FAILURES,         L"OID_FDDI_LCT_FAILURES" },
   { OID_FDDI_LEM_REJECTS,          L"OID_FDDI_LEM_REJECTS" },
   { OID_FDDI_LCONNECTION_STATE,    L"OID_FDDI_LCONNECTION_STATE" },
   { OID_FDDI_SMT_STATION_ID,       L"OID_FDDI_SMT_STATION_ID" },
   { OID_FDDI_SMT_OP_VERSION_ID,    L"OID_FDDI_SMT_OP_VERSION_ID" },
   { OID_FDDI_SMT_HI_VERSION_ID,    L"OID_FDDI_SMT_HI_VERSION_ID" },
   { OID_FDDI_SMT_LO_VERSION_ID,    L"OID_FDDI_SMT_LO_VERSION_ID" },
   { OID_FDDI_SMT_MANUFACTURER_DATA,   L"OID_FDDI_SMT_MANUFACTURER_DATA" },
   { OID_FDDI_SMT_USER_DATA,        L"OID_FDDI_SMT_USER_DATA" },
   { OID_FDDI_SMT_MIB_VERSION_ID,   L"OID_FDDI_SMT_MIB_VERSION_ID" },
   { OID_FDDI_SMT_MAC_CT,           L"OID_FDDI_SMT_MAC_CT" },
   { OID_FDDI_SMT_NON_MASTER_CT,    L"OID_FDDI_SMT_NON_MASTER_CT" },
   { OID_FDDI_SMT_MASTER_CT,        L"OID_FDDI_SMT_MASTER_CT" },
   { OID_FDDI_SMT_AVAILABLE_PATHS,  L"OID_FDDI_SMT_AVAILABLE_PATHS" },
   { OID_FDDI_SMT_CONFIG_CAPABILITIES,   L"OID_FDDI_SMT_CONFIG_CAPABILITIES" },
   { OID_FDDI_SMT_CONFIG_POLICY,    L"OID_FDDI_SMT_CONFIG_POLICY" },
   { OID_FDDI_SMT_CONNECTION_POLICY,   L"OID_FDDI_SMT_CONNECTION_POLICY" },
   { OID_FDDI_SMT_T_NOTIFY,         L"OID_FDDI_SMT_T_NOTIFY" },
   { OID_FDDI_SMT_STAT_RPT_POLICY,  L"OID_FDDI_SMT_STAT_RPT_POLICY" },
   { OID_FDDI_SMT_TRACE_MAX_EXPIRATION,   L"OID_FDDI_SMT_TRACE_MAX_EXPIRATION" },
   { OID_FDDI_SMT_PORT_INDEXES,     L"OID_FDDI_SMT_PORT_INDEXES" },
   { OID_FDDI_SMT_MAC_INDEXES,      L"OID_FDDI_SMT_MAC_INDEXES" },
   { OID_FDDI_SMT_BYPASS_PRESENT,   L"OID_FDDI_SMT_BYPASS_PRESENT" },
   { OID_FDDI_SMT_ECM_STATE,        L"OID_FDDI_SMT_ECM_STATE" },
   { OID_FDDI_SMT_CF_STATE,         L"OID_FDDI_SMT_CF_STATE" },
   { OID_FDDI_SMT_HOLD_STATE,       L"OID_FDDI_SMT_HOLD_STATE" },
   { OID_FDDI_SMT_REMOTE_DISCONNECT_FLAG,   L"OID_FDDI_SMT_REMOTE_DISCONNECT_FLAG" },
   { OID_FDDI_SMT_STATION_STATUS,   L"OID_FDDI_SMT_STATION_STATUS" },
   { OID_FDDI_SMT_PEER_WRAP_FLAG,   L"OID_FDDI_SMT_PEER_WRAP_FLAG" },
   { OID_FDDI_SMT_MSG_TIME_STAMP,   L"OID_FDDI_SMT_MSG_TIME_STAMP" },
   { OID_FDDI_SMT_TRANSITION_TIME_STAMP,   L"OID_FDDI_SMT_TRANSITION_TIME_STAMP" },
   { OID_FDDI_SMT_SET_COUNT,        L"OID_FDDI_SMT_SET_COUNT" },
   { OID_FDDI_SMT_LAST_SET_STATION_ID,   L"OID_FDDI_SMT_LAST_SET_STATION_ID" },
   { OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS,   L"OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS" },
   { OID_FDDI_MAC_BRIDGE_FUNCTIONS, L"OID_FDDI_MAC_BRIDGE_FUNCTIONS" },
   { OID_FDDI_MAC_T_MAX_CAPABILITY, L"OID_FDDI_MAC_T_MAX_CAPABILITY" },
   { OID_FDDI_MAC_TVX_CAPABILITY,   L"OID_FDDI_MAC_TVX_CAPABILITY" },
   { OID_FDDI_MAC_AVAILABLE_PATHS,  L"OID_FDDI_MAC_AVAILABLE_PATHS" },
   { OID_FDDI_MAC_CURRENT_PATH,     L"OID_FDDI_MAC_CURRENT_PATH" },
   { OID_FDDI_MAC_UPSTREAM_NBR,     L"OID_FDDI_MAC_UPSTREAM_NBR" },
   { OID_FDDI_MAC_DOWNSTREAM_NBR,   L"OID_FDDI_MAC_DOWNSTREAM_NBR" },
   { OID_FDDI_MAC_OLD_UPSTREAM_NBR, L"OID_FDDI_MAC_OLD_UPSTREAM_NBR" },
   { OID_FDDI_MAC_OLD_DOWNSTREAM_NBR,   L"OID_FDDI_MAC_OLD_DOWNSTREAM_NBR" },
   { OID_FDDI_MAC_DUP_ADDRESS_TEST, L"OID_FDDI_MAC_DUP_ADDRESS_TEST" },
   { OID_FDDI_MAC_REQUESTED_PATHS,  L"OID_FDDI_MAC_REQUESTED_PATHS" },
   { OID_FDDI_MAC_DOWNSTREAM_PORT_TYPE,   L"OID_FDDI_MAC_DOWNSTREAM_PORT_TYPE" },
   { OID_FDDI_MAC_INDEX,            L"OID_FDDI_MAC_INDEX" },
   { OID_FDDI_MAC_SMT_ADDRESS,      L"OID_FDDI_MAC_SMT_ADDRESS" },
   { OID_FDDI_MAC_LONG_GRP_ADDRESS, L"OID_FDDI_MAC_LONG_GRP_ADDRESS" },
   { OID_FDDI_MAC_SHORT_GRP_ADDRESS,   L"OID_FDDI_MAC_SHORT_GRP_ADDRESS" },
   { OID_FDDI_MAC_T_REQ,            L"OID_FDDI_MAC_T_REQ" },
   { OID_FDDI_MAC_T_NEG,            L"OID_FDDI_MAC_T_NEG" },
   { OID_FDDI_MAC_T_MAX,            L"OID_FDDI_MAC_T_MAX" },
   { OID_FDDI_MAC_TVX_VALUE,        L"OID_FDDI_MAC_TVX_VALUE" },
   { OID_FDDI_MAC_T_PRI0,           L"OID_FDDI_MAC_T_PRI0" },
   { OID_FDDI_MAC_T_PRI1,           L"OID_FDDI_MAC_T_PRI1" },
   { OID_FDDI_MAC_T_PRI2,           L"OID_FDDI_MAC_T_PRI2" },
   { OID_FDDI_MAC_T_PRI3,           L"OID_FDDI_MAC_T_PRI3" },
   { OID_FDDI_MAC_T_PRI4,           L"OID_FDDI_MAC_T_PRI4" },
   { OID_FDDI_MAC_T_PRI5,           L"OID_FDDI_MAC_T_PRI5" },
   { OID_FDDI_MAC_T_PRI6,           L"OID_FDDI_MAC_T_PRI6" },
   { OID_FDDI_MAC_FRAME_CT,         L"OID_FDDI_MAC_FRAME_CT" },
   { OID_FDDI_MAC_COPIED_CT,        L"OID_FDDI_MAC_COPIED_CT" },
   { OID_FDDI_MAC_TRANSMIT_CT,      L"OID_FDDI_MAC_TRANSMIT_CT" },
   { OID_FDDI_MAC_TOKEN_CT,         L"OID_FDDI_MAC_TOKEN_CT" },
   { OID_FDDI_MAC_ERROR_CT,         L"OID_FDDI_MAC_ERROR_CT" },
   { OID_FDDI_MAC_LOST_CT,          L"OID_FDDI_MAC_LOST_CT" },
   { OID_FDDI_MAC_TVX_EXPIRED_CT,   L"OID_FDDI_MAC_TVX_EXPIRED_CT" },
   { OID_FDDI_MAC_NOT_COPIED_CT,    L"OID_FDDI_MAC_NOT_COPIED_CT" },
   { OID_FDDI_MAC_LATE_CT,          L"OID_FDDI_MAC_LATE_CT" },
   { OID_FDDI_MAC_RING_OP_CT,       L"OID_FDDI_MAC_RING_OP_CT" },
   { OID_FDDI_MAC_FRAME_ERROR_THRESHOLD,   L"OID_FDDI_MAC_FRAME_ERROR_THRESHOLD" },
   { OID_FDDI_MAC_FRAME_ERROR_RATIO,   L"OID_FDDI_MAC_FRAME_ERROR_RATIO" },
   { OID_FDDI_MAC_NOT_COPIED_THRESHOLD,   L"OID_FDDI_MAC_NOT_COPIED_THRESHOLD" },
   { OID_FDDI_MAC_NOT_COPIED_RATIO, L"OID_FDDI_MAC_NOT_COPIED_RATIO" },
   { OID_FDDI_MAC_RMT_STATE,        L"OID_FDDI_MAC_RMT_STATE" },
   { OID_FDDI_MAC_DA_FLAG,          L"OID_FDDI_MAC_DA_FLAG" },
   { OID_FDDI_MAC_UNDA_FLAG,        L"OID_FDDI_MAC_UNDA_FLAG" },
   { OID_FDDI_MAC_FRAME_ERROR_FLAG, L"OID_FDDI_MAC_FRAME_ERROR_FLAG" },
   { OID_FDDI_MAC_NOT_COPIED_FLAG,  L"OID_FDDI_MAC_NOT_COPIED_FLAG" },
   { OID_FDDI_MAC_MA_UNITDATA_AVAILABLE,   L"OID_FDDI_MAC_MA_UNITDATA_AVAILABLE" },
   { OID_FDDI_MAC_HARDWARE_PRESENT, L"OID_FDDI_MAC_HARDWARE_PRESENT" },
   { OID_FDDI_MAC_MA_UNITDATA_ENABLE,   L"OID_FDDI_MAC_MA_UNITDATA_ENABLE" },
   { OID_FDDI_PATH_INDEX,           L"OID_FDDI_PATH_INDEX" },
   { OID_FDDI_PATH_RING_LATENCY,    L"OID_FDDI_PATH_RING_LATENCY" },
   { OID_FDDI_PATH_TRACE_STATUS,    L"OID_FDDI_PATH_TRACE_STATUS" },
   { OID_FDDI_PATH_SBA_PAYLOAD,     L"OID_FDDI_PATH_SBA_PAYLOAD" },
   { OID_FDDI_PATH_SBA_OVERHEAD,    L"OID_FDDI_PATH_SBA_OVERHEAD" },
   { OID_FDDI_PATH_CONFIGURATION,   L"OID_FDDI_PATH_CONFIGURATION" },
   { OID_FDDI_PATH_T_R_MODE,        L"OID_FDDI_PATH_T_R_MODE" },
   { OID_FDDI_PATH_SBA_AVAILABLE,   L"OID_FDDI_PATH_SBA_AVAILABLE" },
   { OID_FDDI_PATH_TVX_LOWER_BOUND, L"OID_FDDI_PATH_TVX_LOWER_BOUND" },
   { OID_FDDI_PATH_T_MAX_LOWER_BOUND,   L"OID_FDDI_PATH_T_MAX_LOWER_BOUND" },
   { OID_FDDI_PATH_MAX_T_REQ,       L"OID_FDDI_PATH_MAX_T_REQ" },
   { OID_FDDI_PORT_MY_TYPE,         L"OID_FDDI_PORT_MY_TYPE" },
   { OID_FDDI_PORT_NEIGHBOR_TYPE,   L"OID_FDDI_PORT_NEIGHBOR_TYPE" },
   { OID_FDDI_PORT_CONNECTION_POLICIES,   L"OID_FDDI_PORT_CONNECTION_POLICIES" },
   { OID_FDDI_PORT_MAC_INDICATED,   L"OID_FDDI_PORT_MAC_INDICATED" },
   { OID_FDDI_PORT_CURRENT_PATH,    L"OID_FDDI_PORT_CURRENT_PATH" },
   { OID_FDDI_PORT_REQUESTED_PATHS, L"OID_FDDI_PORT_REQUESTED_PATHS" },
   { OID_FDDI_PORT_MAC_PLACEMENT,   L"OID_FDDI_PORT_MAC_PLACEMENT" },
   { OID_FDDI_PORT_AVAILABLE_PATHS, L"OID_FDDI_PORT_AVAILABLE_PATHS" },
   { OID_FDDI_PORT_MAC_LOOP_TIME,   L"OID_FDDI_PORT_MAC_LOOP_TIME" },
   { OID_FDDI_PORT_PMD_CLASS,       L"OID_FDDI_PORT_PMD_CLASS" },
   { OID_FDDI_PORT_CONNECTION_CAPABILITIES,   L"OID_FDDI_PORT_CONNECTION_CAPABILITIES" },
   { OID_FDDI_PORT_INDEX,           L"OID_FDDI_PORT_INDEX" },
   { OID_FDDI_PORT_MAINT_LS,        L"OID_FDDI_PORT_MAINT_LS" },
   { OID_FDDI_PORT_BS_FLAG,         L"OID_FDDI_PORT_BS_FLAG" },
   { OID_FDDI_PORT_PC_LS,           L"OID_FDDI_PORT_PC_LS" },
   { OID_FDDI_PORT_EB_ERROR_CT,     L"OID_FDDI_PORT_EB_ERROR_CT" },
   { OID_FDDI_PORT_LCT_FAIL_CT,     L"OID_FDDI_PORT_LCT_FAIL_CT" },
   { OID_FDDI_PORT_LER_ESTIMATE,    L"OID_FDDI_PORT_LER_ESTIMATE" },
   { OID_FDDI_PORT_LEM_REJECT_CT,   L"OID_FDDI_PORT_LEM_REJECT_CT" },
   { OID_FDDI_PORT_LEM_CT,          L"OID_FDDI_PORT_LEM_CT" },
   { OID_FDDI_PORT_LER_CUTOFF,      L"OID_FDDI_PORT_LER_CUTOFF" },
   { OID_FDDI_PORT_LER_ALARM,       L"OID_FDDI_PORT_LER_ALARM" },
   { OID_FDDI_PORT_CONNNECT_STATE,  L"OID_FDDI_PORT_CONNNECT_STATE" },
   { OID_FDDI_PORT_PCM_STATE,       L"OID_FDDI_PORT_PCM_STATE" },
   { OID_FDDI_PORT_PC_WITHHOLD,     L"OID_FDDI_PORT_PC_WITHHOLD" },
   { OID_FDDI_PORT_LER_FLAG,        L"OID_FDDI_PORT_LER_FLAG" },
   { OID_FDDI_PORT_HARDWARE_PRESENT,   L"OID_FDDI_PORT_HARDWARE_PRESENT" },
   { OID_FDDI_SMT_STATION_ACTION,   L"OID_FDDI_SMT_STATION_ACTION" },
   { OID_FDDI_PORT_ACTION,          L"OID_FDDI_PORT_ACTION" },
   { OID_FDDI_IF_DESCR,             L"OID_FDDI_IF_DESCR" },
   { OID_FDDI_IF_TYPE,              L"OID_FDDI_IF_TYPE" },
   { OID_FDDI_IF_MTU,               L"OID_FDDI_IF_MTU" },
   { OID_FDDI_IF_SPEED,             L"OID_FDDI_IF_SPEED" },
   { OID_FDDI_IF_PHYS_ADDRESS,      L"OID_FDDI_IF_PHYS_ADDRESS" },
   { OID_FDDI_IF_ADMIN_STATUS,      L"OID_FDDI_IF_ADMIN_STATUS" },
   { OID_FDDI_IF_OPER_STATUS,       L"OID_FDDI_IF_OPER_STATUS" },
   { OID_FDDI_IF_LAST_CHANGE,       L"OID_FDDI_IF_LAST_CHANGE" },
   { OID_FDDI_IF_IN_OCTETS,         L"OID_FDDI_IF_IN_OCTETS" },
   { OID_FDDI_IF_IN_UCAST_PKTS,     L"OID_FDDI_IF_IN_UCAST_PKTS" },
   { OID_FDDI_IF_IN_NUCAST_PKTS,    L"OID_FDDI_IF_IN_NUCAST_PKTS" },
   { OID_FDDI_IF_IN_DISCARDS,       L"OID_FDDI_IF_IN_DISCARDS" },
   { OID_FDDI_IF_IN_ERRORS,         L"OID_FDDI_IF_IN_ERRORS" },
   { OID_FDDI_IF_IN_UNKNOWN_PROTOS, L"OID_FDDI_IF_IN_UNKNOWN_PROTOS" },
   { OID_FDDI_IF_OUT_OCTETS,        L"OID_FDDI_IF_OUT_OCTETS" },
   { OID_FDDI_IF_OUT_UCAST_PKTS,    L"OID_FDDI_IF_OUT_UCAST_PKTS" },
   { OID_FDDI_IF_OUT_NUCAST_PKTS,   L"OID_FDDI_IF_OUT_NUCAST_PKTS" },
   { OID_FDDI_IF_OUT_DISCARDS,      L"OID_FDDI_IF_OUT_DISCARDS" },
   { OID_FDDI_IF_OUT_ERRORS,        L"OID_FDDI_IF_OUT_ERRORS" },
   { OID_FDDI_IF_OUT_QLEN,          L"OID_FDDI_IF_OUT_QLEN" },
   { OID_FDDI_IF_SPECIFIC,          L"OID_FDDI_IF_SPECIFIC" },
   { OID_WAN_PERMANENT_ADDRESS,     L"OID_WAN_PERMANENT_ADDRESS" },
   { OID_WAN_CURRENT_ADDRESS,       L"OID_WAN_CURRENT_ADDRESS" },
   { OID_WAN_QUALITY_OF_SERVICE,    L"OID_WAN_QUALITY_OF_SERVICE" },
   { OID_WAN_PROTOCOL_TYPE,         L"OID_WAN_PROTOCOL_TYPE" },
   { OID_WAN_MEDIUM_SUBTYPE,        L"OID_WAN_MEDIUM_SUBTYPE" },
   { OID_WAN_HEADER_FORMAT,         L"OID_WAN_HEADER_FORMAT" },
   { OID_WAN_GET_INFO,              L"OID_WAN_GET_INFO" },
   { OID_WAN_SET_LINK_INFO,         L"OID_WAN_SET_LINK_INFO" },
   { OID_WAN_GET_LINK_INFO,         L"OID_WAN_GET_LINK_INFO" },
   { OID_WAN_LINE_COUNT,            L"OID_WAN_LINE_COUNT" },
   { OID_WAN_PROTOCOL_CAPS,         L"OID_WAN_PROTOCOL_CAPS" },
   { OID_WAN_GET_BRIDGE_INFO,       L"OID_WAN_GET_BRIDGE_INFO" },
   { OID_WAN_SET_BRIDGE_INFO,       L"OID_WAN_SET_BRIDGE_INFO" },
   { OID_WAN_GET_COMP_INFO,         L"OID_WAN_GET_COMP_INFO" },
   { OID_WAN_SET_COMP_INFO,         L"OID_WAN_SET_COMP_INFO" },
   { OID_WAN_GET_STATS_INFO,        L"OID_WAN_GET_STATS_INFO" },
   { OID_WAN_CO_GET_INFO,           L"OID_WAN_CO_GET_INFO" },
   { OID_WAN_CO_SET_LINK_INFO,      L"OID_WAN_CO_SET_LINK_INFO" },
   { OID_WAN_CO_GET_LINK_INFO,      L"OID_WAN_CO_GET_LINK_INFO" },
   { OID_WAN_CO_GET_COMP_INFO,      L"OID_WAN_CO_GET_COMP_INFO" },
   { OID_WAN_CO_SET_COMP_INFO,      L"OID_WAN_CO_SET_COMP_INFO" },
   { OID_WAN_CO_GET_STATS_INFO,     L"OID_WAN_CO_GET_STATS_INFO" },
   { OID_LTALK_CURRENT_NODE_ID,     L"OID_LTALK_CURRENT_NODE_ID" },
   { OID_LTALK_IN_BROADCASTS,       L"OID_LTALK_IN_BROADCASTS" },
   { OID_LTALK_IN_LENGTH_ERRORS,    L"OID_LTALK_IN_LENGTH_ERRORS" },
   { OID_LTALK_OUT_NO_HANDLERS,     L"OID_LTALK_OUT_NO_HANDLERS" },
   { OID_LTALK_COLLISIONS,          L"OID_LTALK_COLLISIONS" },
   { OID_LTALK_DEFERS,              L"OID_LTALK_DEFERS" },
   { OID_LTALK_NO_DATA_ERRORS,      L"OID_LTALK_NO_DATA_ERRORS" },
   { OID_LTALK_RANDOM_CTS_ERRORS,   L"OID_LTALK_RANDOM_CTS_ERRORS" },
   { OID_LTALK_FCS_ERRORS,          L"OID_LTALK_FCS_ERRORS" },
   { OID_ARCNET_PERMANENT_ADDRESS,  L"OID_ARCNET_PERMANENT_ADDRESS" },
   { OID_ARCNET_CURRENT_ADDRESS,    L"OID_ARCNET_CURRENT_ADDRESS" },
   { OID_ARCNET_RECONFIGURATIONS,   L"OID_ARCNET_RECONFIGURATIONS" },
   { OID_TAPI_ACCEPT,               L"OID_TAPI_ACCEPT" },
   { OID_TAPI_ANSWER,               L"OID_TAPI_ANSWER" },
   { OID_TAPI_CLOSE,                L"OID_TAPI_CLOSE" },
   { OID_TAPI_CLOSE_CALL,           L"OID_TAPI_CLOSE_CALL" },
   { OID_TAPI_CONDITIONAL_MEDIA_DETECTION,   L"OID_TAPI_CONDITIONAL_MEDIA_DETECTION" },
   { OID_TAPI_CONFIG_DIALOG,        L"OID_TAPI_CONFIG_DIALOG" },
   { OID_TAPI_DEV_SPECIFIC,         L"OID_TAPI_DEV_SPECIFIC" },
   { OID_TAPI_DIAL,                 L"OID_TAPI_DIAL" },
   { OID_TAPI_DROP,                 L"OID_TAPI_DROP" },
   { OID_TAPI_GET_ADDRESS_CAPS,     L"OID_TAPI_GET_ADDRESS_CAPS" },
   { OID_TAPI_GET_ADDRESS_ID,       L"OID_TAPI_GET_ADDRESS_ID" },
   { OID_TAPI_GET_ADDRESS_STATUS,   L"OID_TAPI_GET_ADDRESS_STATUS" },
   { OID_TAPI_GET_CALL_ADDRESS_ID,  L"OID_TAPI_GET_CALL_ADDRESS_ID" },
   { OID_TAPI_GET_CALL_INFO,        L"OID_TAPI_GET_CALL_INFO" },
   { OID_TAPI_GET_CALL_STATUS,      L"OID_TAPI_GET_CALL_STATUS" },
   { OID_TAPI_GET_DEV_CAPS,         L"OID_TAPI_GET_DEV_CAPS" },
   { OID_TAPI_GET_DEV_CONFIG,       L"OID_TAPI_GET_DEV_CONFIG" },
   { OID_TAPI_GET_EXTENSION_ID,     L"OID_TAPI_GET_EXTENSION_ID" },
   { OID_TAPI_GET_ID,               L"OID_TAPI_GET_ID" },
   { OID_TAPI_GET_LINE_DEV_STATUS,  L"OID_TAPI_GET_LINE_DEV_STATUS" },
   { OID_TAPI_MAKE_CALL,            L"OID_TAPI_MAKE_CALL" },
   { OID_TAPI_NEGOTIATE_EXT_VERSION,   L"OID_TAPI_NEGOTIATE_EXT_VERSION" },
   { OID_TAPI_OPEN,                 L"OID_TAPI_OPEN" },
   { OID_TAPI_PROVIDER_INITIALIZE,  L"OID_TAPI_PROVIDER_INITIALIZE" },
   { OID_TAPI_PROVIDER_SHUTDOWN,    L"OID_TAPI_PROVIDER_SHUTDOWN" },
   { OID_TAPI_SECURE_CALL,          L"OID_TAPI_SECURE_CALL" },
   { OID_TAPI_SELECT_EXT_VERSION,   L"OID_TAPI_SELECT_EXT_VERSION" },
   { OID_TAPI_SEND_USER_USER_INFO,  L"OID_TAPI_SEND_USER_USER_INFO" },
   { OID_TAPI_SET_APP_SPECIFIC,     L"OID_TAPI_SET_APP_SPECIFIC" },
   { OID_TAPI_SET_CALL_PARAMS,      L"OID_TAPI_SET_CALL_PARAMS" },
   { OID_TAPI_SET_DEFAULT_MEDIA_DETECTION,   L"OID_TAPI_SET_DEFAULT_MEDIA_DETECTION" },
   { OID_TAPI_SET_DEV_CONFIG,       L"OID_TAPI_SET_DEV_CONFIG" },
   { OID_TAPI_SET_MEDIA_MODE,       L"OID_TAPI_SET_MEDIA_MODE" },
   { OID_TAPI_SET_STATUS_MESSAGES,  L"OID_TAPI_SET_STATUS_MESSAGES" },
   { OID_TAPI_GATHER_DIGITS,        L"OID_TAPI_GATHER_DIGITS" },
   { OID_TAPI_MONITOR_DIGITS,       L"OID_TAPI_MONITOR_DIGITS" },
   { OID_TAPI_TRANSLATE_ADDRESS,    L"OID_TAPI_TRANSLATE_ADDRESS" },
   { OID_TAPI_CONFIG_DIALOG_EDIT,   L"OID_TAPI_CONFIG_DIALOG_EDIT" },
   { OID_ATM_SUPPORTED_VC_RATES,    L"OID_ATM_SUPPORTED_VC_RATES" },
   { OID_ATM_SUPPORTED_SERVICE_CATEGORY,   L"OID_ATM_SUPPORTED_SERVICE_CATEGORY" },
   { OID_ATM_SUPPORTED_AAL_TYPES,   L"OID_ATM_SUPPORTED_AAL_TYPES" },
   { OID_ATM_HW_CURRENT_ADDRESS,    L"OID_ATM_HW_CURRENT_ADDRESS" },
   { OID_ATM_MAX_ACTIVE_VCS,        L"OID_ATM_MAX_ACTIVE_VCS" },
   { OID_ATM_MAX_ACTIVE_VCI_BITS,   L"OID_ATM_MAX_ACTIVE_VCI_BITS" },
   { OID_ATM_MAX_ACTIVE_VPI_BITS,   L"OID_ATM_MAX_ACTIVE_VPI_BITS" },
   { OID_ATM_MAX_AAL0_PACKET_SIZE,  L"OID_ATM_MAX_AAL0_PACKET_SIZE" },
   { OID_ATM_MAX_AAL1_PACKET_SIZE,  L"OID_ATM_MAX_AAL1_PACKET_SIZE" },
   { OID_ATM_MAX_AAL34_PACKET_SIZE, L"OID_ATM_MAX_AAL34_PACKET_SIZE" },
   { OID_ATM_MAX_AAL5_PACKET_SIZE,  L"OID_ATM_MAX_AAL5_PACKET_SIZE" },
   { OID_ATM_SIGNALING_VPIVCI,      L"OID_ATM_SIGNALING_VPIVCI" },
   { OID_ATM_ASSIGNED_VPI,          L"OID_ATM_ASSIGNED_VPI" },
   { OID_ATM_ACQUIRE_ACCESS_NET_RESOURCES,   L"OID_ATM_ACQUIRE_ACCESS_NET_RESOURCES" },
   { OID_ATM_RELEASE_ACCESS_NET_RESOURCES,   L"OID_ATM_RELEASE_ACCESS_NET_RESOURCES" },
   { OID_ATM_ILMI_VPIVCI,           L"OID_ATM_ILMI_VPIVCI" },
   { OID_ATM_DIGITAL_BROADCAST_VPIVCI,   L"OID_ATM_DIGITAL_BROADCAST_VPIVCI" },
   { OID_ATM_GET_NEAREST_FLOW,      L"OID_ATM_GET_NEAREST_FLOW" },
   { OID_ATM_ALIGNMENT_REQUIRED,    L"OID_ATM_ALIGNMENT_REQUIRED" },
   { OID_ATM_LECS_ADDRESS,          L"OID_ATM_LECS_ADDRESS" },
   { OID_ATM_SERVICE_ADDRESS,       L"OID_ATM_SERVICE_ADDRESS" },
   { OID_ATM_CALL_PROCEEDING,       L"OID_ATM_CALL_PROCEEDING" },
   { OID_ATM_CALL_ALERTING,         L"OID_ATM_CALL_ALERTING" },
   { OID_ATM_PARTY_ALERTING,        L"OID_ATM_PARTY_ALERTING" },
   { OID_ATM_CALL_NOTIFY,           L"OID_ATM_CALL_NOTIFY" },
   { OID_ATM_MY_IP_NM_ADDRESS,      L"OID_ATM_MY_IP_NM_ADDRESS" },
   { OID_ATM_RCV_CELLS_OK,          L"OID_ATM_RCV_CELLS_OK" },
   { OID_ATM_XMIT_CELLS_OK,         L"OID_ATM_XMIT_CELLS_OK" },
   { OID_ATM_RCV_CELLS_DROPPED,     L"OID_ATM_RCV_CELLS_DROPPED" },
   { OID_ATM_RCV_INVALID_VPI_VCI,   L"OID_ATM_RCV_INVALID_VPI_VCI" },
   { OID_ATM_CELLS_HEC_ERROR,       L"OID_ATM_CELLS_HEC_ERROR" },
   { OID_ATM_RCV_REASSEMBLY_ERROR,  L"OID_ATM_RCV_REASSEMBLY_ERROR" },
   { OID_WW_GEN_NETWORK_TYPES_SUPPORTED,   L"OID_WW_GEN_NETWORK_TYPES_SUPPORTED" },
   { OID_WW_GEN_NETWORK_TYPE_IN_USE,   L"OID_WW_GEN_NETWORK_TYPE_IN_USE" },
   { OID_WW_GEN_HEADER_FORMATS_SUPPORTED,   L"OID_WW_GEN_HEADER_FORMATS_SUPPORTED" },
   { OID_WW_GEN_HEADER_FORMAT_IN_USE,   L"OID_WW_GEN_HEADER_FORMAT_IN_USE" },
   { OID_WW_GEN_INDICATION_REQUEST, L"OID_WW_GEN_INDICATION_REQUEST" },
   { OID_WW_GEN_DEVICE_INFO,        L"OID_WW_GEN_DEVICE_INFO" },
   { OID_WW_GEN_OPERATION_MODE,     L"OID_WW_GEN_OPERATION_MODE" },
   { OID_WW_GEN_LOCK_STATUS,        L"OID_WW_GEN_LOCK_STATUS" },
   { OID_WW_GEN_DISABLE_TRANSMITTER,   L"OID_WW_GEN_DISABLE_TRANSMITTER" },
   { OID_WW_GEN_NETWORK_ID,         L"OID_WW_GEN_NETWORK_ID" },
   { OID_WW_GEN_PERMANENT_ADDRESS,  L"OID_WW_GEN_PERMANENT_ADDRESS" },
   { OID_WW_GEN_CURRENT_ADDRESS,    L"OID_WW_GEN_CURRENT_ADDRESS" },
   { OID_WW_GEN_SUSPEND_DRIVER,     L"OID_WW_GEN_SUSPEND_DRIVER" },
   { OID_WW_GEN_BASESTATION_ID,     L"OID_WW_GEN_BASESTATION_ID" },
   { OID_WW_GEN_CHANNEL_ID,         L"OID_WW_GEN_CHANNEL_ID" },
   { OID_WW_GEN_ENCRYPTION_SUPPORTED,   L"OID_WW_GEN_ENCRYPTION_SUPPORTED" },
   { OID_WW_GEN_ENCRYPTION_IN_USE,  L"OID_WW_GEN_ENCRYPTION_IN_USE" },
   { OID_WW_GEN_ENCRYPTION_STATE,   L"OID_WW_GEN_ENCRYPTION_STATE" },
   { OID_WW_GEN_CHANNEL_QUALITY,    L"OID_WW_GEN_CHANNEL_QUALITY" },
   { OID_WW_GEN_REGISTRATION_STATUS,   L"OID_WW_GEN_REGISTRATION_STATUS" },
   { OID_WW_GEN_RADIO_LINK_SPEED,   L"OID_WW_GEN_RADIO_LINK_SPEED" },
   { OID_WW_GEN_LATENCY,            L"OID_WW_GEN_LATENCY" },
   { OID_WW_GEN_BATTERY_LEVEL,      L"OID_WW_GEN_BATTERY_LEVEL" },
   { OID_WW_GEN_EXTERNAL_POWER,     L"OID_WW_GEN_EXTERNAL_POWER" },
   { OID_WW_GEN_PING_ADDRESS,       L"OID_WW_GEN_PING_ADDRESS" },
   { OID_WW_GEN_RSSI,               L"OID_WW_GEN_RSSI" },
   { OID_WW_GEN_SIM_STATUS,         L"OID_WW_GEN_SIM_STATUS" },
   { OID_WW_GEN_ENABLE_SIM_PIN,     L"OID_WW_GEN_ENABLE_SIM_PIN" },
   { OID_WW_GEN_CHANGE_SIM_PIN,     L"OID_WW_GEN_CHANGE_SIM_PIN" },
   { OID_WW_GEN_SIM_PUK,            L"OID_WW_GEN_SIM_PUK" },
   { OID_WW_GEN_SIM_EXCEPTION,      L"OID_WW_GEN_SIM_EXCEPTION" },
   { OID_WW_MBX_SUBADDR,            L"OID_WW_MBX_SUBADDR" },
   { OID_WW_MBX_FLEXLIST,           L"OID_WW_MBX_FLEXLIST" },
   { OID_WW_MBX_GROUPLIST,          L"OID_WW_MBX_GROUPLIST" },
   { OID_WW_MBX_TRAFFIC_AREA,       L"OID_WW_MBX_TRAFFIC_AREA" },
   { OID_WW_MBX_LIVE_DIE,           L"OID_WW_MBX_LIVE_DIE" },
   { OID_WW_MBX_TEMP_DEFAULTLIST,   L"OID_WW_MBX_TEMP_DEFAULTLIST" },
   { OID_WW_PIN_LOC_AUTHORIZE,      L"OID_WW_PIN_LOC_AUTHORIZE" },
   { OID_WW_PIN_LAST_LOCATION,      L"OID_WW_PIN_LAST_LOCATION" },
   { OID_WW_PIN_LOC_FIX,            L"OID_WW_PIN_LOC_FIX" },
   { OID_WW_CDPD_SPNI,              L"OID_WW_CDPD_SPNI" },
   { OID_WW_CDPD_WASI,              L"OID_WW_CDPD_WASI" },
   { OID_WW_CDPD_AREA_COLOR,        L"OID_WW_CDPD_AREA_COLOR" },
   { OID_WW_CDPD_TX_POWER_LEVEL,    L"OID_WW_CDPD_TX_POWER_LEVEL" },
   { OID_WW_CDPD_EID,               L"OID_WW_CDPD_EID" },
   { OID_WW_CDPD_HEADER_COMPRESSION,   L"OID_WW_CDPD_HEADER_COMPRESSION" },
   { OID_WW_CDPD_DATA_COMPRESSION,  L"OID_WW_CDPD_DATA_COMPRESSION" },
   { OID_WW_CDPD_CHANNEL_SELECT,    L"OID_WW_CDPD_CHANNEL_SELECT" },
   { OID_WW_CDPD_CHANNEL_STATE,     L"OID_WW_CDPD_CHANNEL_STATE" },
   { OID_WW_CDPD_NEI,               L"OID_WW_CDPD_NEI" },
   { OID_WW_CDPD_NEI_STATE,         L"OID_WW_CDPD_NEI_STATE" },
   { OID_WW_CDPD_SERVICE_PROVIDER_IDENTIFIER,   L"OID_WW_CDPD_SERVICE_PROVIDER_IDENTIFIER" },
   { OID_WW_CDPD_SLEEP_MODE,        L"OID_WW_CDPD_SLEEP_MODE" },
   { OID_WW_CDPD_CIRCUIT_SWITCHED,  L"OID_WW_CDPD_CIRCUIT_SWITCHED" },
   { OID_WW_CDPD_TEI,               L"OID_WW_CDPD_TEI" },
   { OID_WW_CDPD_RSSI,              L"OID_WW_CDPD_RSSI" },
   { OID_WW_CDPD_CS_SERVICE_PREFERENCE,   L"OID_WW_CDPD_CS_SERVICE_PREFERENCE" },
   { OID_WW_CDPD_CS_SERVICE_STATUS, L"OID_WW_CDPD_CS_SERVICE_STATUS" },
   { OID_WW_CDPD_CS_INFO,           L"OID_WW_CDPD_CS_INFO" },
   { OID_WW_CDPD_CS_SUSPEND,        L"OID_WW_CDPD_CS_SUSPEND" },
   { OID_WW_CDPD_CS_DEFAULT_DIAL_CODE,   L"OID_WW_CDPD_CS_DEFAULT_DIAL_CODE" },
   { OID_WW_CDPD_CS_CALLBACK,       L"OID_WW_CDPD_CS_CALLBACK" },
   { OID_WW_CDPD_CS_SID_LIST,       L"OID_WW_CDPD_CS_SID_LIST" },
   { OID_WW_CDPD_CS_CONFIGURATION,  L"OID_WW_CDPD_CS_CONFIGURATION" },
   { OID_WW_ARD_SNDCP,              L"OID_WW_ARD_SNDCP" },
   { OID_WW_ARD_TMLY_MSG,           L"OID_WW_ARD_TMLY_MSG" },
   { OID_WW_ARD_DATAGRAM,           L"OID_WW_ARD_DATAGRAM" },
   { OID_WW_TAC_COMPRESSION,        L"OID_WW_TAC_COMPRESSION" },
   { OID_WW_TAC_SET_CONFIG,         L"OID_WW_TAC_SET_CONFIG" },
   { OID_WW_TAC_GET_STATUS,         L"OID_WW_TAC_GET_STATUS" },
   { OID_WW_TAC_USER_HEADER,        L"OID_WW_TAC_USER_HEADER" },
   { OID_WW_TAC_UNIQUE_SDU_TAG,     L"OID_WW_TAC_UNIQUE_SDU_TAG" },
   { OID_WW_TAC_SEND_COMMAND,       L"OID_WW_TAC_SEND_COMMAND" },
   { OID_WW_TAC_GET_RESPONSE,       L"OID_WW_TAC_GET_RESPONSE" },
   { OID_WW_TAC_DISABLE_RECEIVER,   L"OID_WW_TAC_DISABLE_RECEIVER" },
   { OID_WW_TAC_ANTENNA_MODE,       L"OID_WW_TAC_ANTENNA_MODE" },
   { OID_WW_TAC_FLUSH_DATA,         L"OID_WW_TAC_FLUSH_DATA" },
   { OID_WW_TAC_SHUTDOWN_DEVICE,    L"OID_WW_TAC_SHUTDOWN_DEVICE" },
   { OID_WW_TAC_DEVICE_EXCEPTION,   L"OID_WW_TAC_DEVICE_EXCEPTION" },
   { OID_WW_TAC_RECEIVE_EXCEPTION,  L"OID_WW_TAC_RECEIVE_EXCEPTION" },
   { OID_WW_TAC_BUFFER_EXCEPTION,   L"OID_WW_TAC_BUFFER_EXCEPTION" },
   { OID_WW_TAC_BATTERY_EXCEPTION,  L"OID_WW_TAC_BATTERY_EXCEPTION" },
   { OID_WW_TAC_TRANSMITTER_KEYED,  L"OID_WW_TAC_TRANSMITTER_KEYED" },
   { OID_WW_TAC_SYSTEM_TABLE,       L"OID_WW_TAC_SYSTEM_TABLE" },
   { OID_WW_TAC_CHANNEL_TABLE,      L"OID_WW_TAC_CHANNEL_TABLE" },
   { OID_WW_TAC_DCHANNEL_TABLE,     L"OID_WW_TAC_DCHANNEL_TABLE" },
   { OID_WW_TAC_RECEIVE_QUEUE_COUNT,   L"OID_WW_TAC_RECEIVE_QUEUE_COUNT" },
   { OID_WW_TAC_STATISTICS,         L"OID_WW_TAC_STATISTICS" },
   { OID_WW_MET_FUNCTION,           L"OID_WW_MET_FUNCTION" },
   { OID_802_11_BSSID,              L"OID_802_11_BSSID" },
   { OID_802_11_SSID,               L"OID_802_11_SSID" },
   { OID_802_11_NETWORK_TYPES_SUPPORTED,   L"OID_802_11_NETWORK_TYPES_SUPPORTED" },
   { OID_802_11_NETWORK_TYPE_IN_USE,   L"OID_802_11_NETWORK_TYPE_IN_USE" },
   { OID_802_11_TX_POWER_LEVEL,     L"OID_802_11_TX_POWER_LEVEL" },
   { OID_802_11_RSSI,               L"OID_802_11_RSSI" },
   { OID_802_11_RSSI_TRIGGER,       L"OID_802_11_RSSI_TRIGGER" },
   { OID_802_11_INFRASTRUCTURE_MODE,   L"OID_802_11_INFRASTRUCTURE_MODE" },
   { OID_802_11_FRAGMENTATION_THRESHOLD,   L"OID_802_11_FRAGMENTATION_THRESHOLD" },
   { OID_802_11_RTS_THRESHOLD,      L"OID_802_11_RTS_THRESHOLD" },
   { OID_802_11_NUMBER_OF_ANTENNAS, L"OID_802_11_NUMBER_OF_ANTENNAS" },
   { OID_802_11_RX_ANTENNA_SELECTED,   L"OID_802_11_RX_ANTENNA_SELECTED" },
   { OID_802_11_TX_ANTENNA_SELECTED,   L"OID_802_11_TX_ANTENNA_SELECTED" },
   { OID_802_11_SUPPORTED_RATES,    L"OID_802_11_SUPPORTED_RATES" },
   { OID_802_11_DESIRED_RATES,      L"OID_802_11_DESIRED_RATES" },
   { OID_802_11_CONFIGURATION,      L"OID_802_11_CONFIGURATION" },
   { OID_802_11_STATISTICS,         L"OID_802_11_STATISTICS" },
   { OID_802_11_ADD_WEP,            L"OID_802_11_ADD_WEP" },
   { OID_802_11_REMOVE_WEP,         L"OID_802_11_REMOVE_WEP" },
   { OID_802_11_DISASSOCIATE,       L"OID_802_11_DISASSOCIATE" },
   { OID_802_11_POWER_MODE,         L"OID_802_11_POWER_MODE" },
   { OID_802_11_BSSID_LIST,         L"OID_802_11_BSSID_LIST" },
   { OID_802_11_AUTHENTICATION_MODE,   L"OID_802_11_AUTHENTICATION_MODE" },
   { OID_802_11_PRIVACY_FILTER,     L"OID_802_11_PRIVACY_FILTER" },
   { OID_802_11_BSSID_LIST_SCAN,    L"OID_802_11_BSSID_LIST_SCAN" },
   { OID_802_11_WEP_STATUS,         L"OID_802_11_WEP_STATUS" },
   { OID_802_11_ENCRYPTION_STATUS,  L"OID_802_11_ENCRYPTION_STATUS" },
   { OID_802_11_RELOAD_DEFAULTS,    L"OID_802_11_RELOAD_DEFAULTS" },
   { OID_NDIS_BLOCK_MEDIA_CONNECT,  L"OID_NDIS_BLOCK_MEDIA_CONNECT" },
   { OID_NDIS_UNBLOCK_MEDIA_CONNECT,   L"OID_NDIS_UNBLOCK_MEDIA_CONNECT" },
   { OID_NDIS_EMULATE_MEDIA_CONNECT,   L"OID_NDIS_EMULATE_MEDIA_CONNECT" },
   { OID_NDIS_EMULATE_MEDIA_DISCONNECT,   L"OID_NDIS_EMULATE_MEDIA_DISCONNECT" },
   { OID_802_11_ADD_KEY,            L"OID_802_11_ADD_KEY" },
   { OID_802_11_REMOVE_KEY,         L"OID_802_11_REMOVE_KEY" },
   { OID_802_11_ASSOCIATION_INFORMATION,   L"OID_802_11_ASSOCIATION_INFORMATION" },
   { OID_802_11_TEST,               L"OID_802_11_TEST" },
   { OID_IRDA_RECEIVING,            L"OID_IRDA_RECEIVING" },
   { OID_IRDA_TURNAROUND_TIME,      L"OID_IRDA_TURNAROUND_TIME" },
   { OID_IRDA_SUPPORTED_SPEEDS,     L"OID_IRDA_SUPPORTED_SPEEDS" },
   { OID_IRDA_LINK_SPEED,           L"OID_IRDA_LINK_SPEED" },
   { OID_IRDA_MEDIA_BUSY,           L"OID_IRDA_MEDIA_BUSY" },
   { OID_IRDA_EXTRA_RCV_BOFS,       L"OID_IRDA_EXTRA_RCV_BOFS" },
   { OID_IRDA_RATE_SNIFF,           L"OID_IRDA_RATE_SNIFF" },
   { OID_IRDA_UNICAST_LIST,         L"OID_IRDA_UNICAST_LIST" },
   { OID_IRDA_MAX_UNICAST_LIST_SIZE,   L"OID_IRDA_MAX_UNICAST_LIST_SIZE" },
   { OID_IRDA_MAX_RECEIVE_WINDOW_SIZE,   L"OID_IRDA_MAX_RECEIVE_WINDOW_SIZE" },
   { OID_IRDA_MAX_SEND_WINDOW_SIZE, L"OID_IRDA_MAX_SEND_WINDOW_SIZE" },
   { OID_IRDA_RELEASE_HW_RESOURCES, L"OID_IRDA_RELEASE_HW_RESOURCES" },
   { OID_IRDA_REACQUIRE_HW_RESOURCES,   L"OID_IRDA_REACQUIRE_HW_RESOURCES" },
   { OID_IRDA_RESERVED1,            L"OID_IRDA_RESERVED1" },
   { OID_IRDA_RESERVED2,            L"OID_IRDA_RESERVED2" },
   { OID_BPC_ADAPTER_CAPS,          L"OID_BPC_ADAPTER_CAPS" },
   { OID_BPC_DEVICES,               L"OID_BPC_DEVICES" },
   { OID_BPC_DEVICE_CAPS,           L"OID_BPC_DEVICE_CAPS" },
   { OID_BPC_DEVICE_SETTINGS,       L"OID_BPC_DEVICE_SETTINGS" },
   { OID_BPC_CONNECTION_STATUS,     L"OID_BPC_CONNECTION_STATUS" },
   { OID_BPC_ADDRESS_COMPARE,       L"OID_BPC_ADDRESS_COMPARE" },
   { OID_BPC_PROGRAM_GUIDE,         L"OID_BPC_PROGRAM_GUIDE" },
   { OID_BPC_LAST_ERROR,            L"OID_BPC_LAST_ERROR" },
   { OID_BPC_POOL,                  L"OID_BPC_POOL" },
   { OID_BPC_PROVIDER_SPECIFIC,     L"OID_BPC_PROVIDER_SPECIFIC" },
   { OID_BPC_ADAPTER_SPECIFIC,      L"OID_BPC_ADAPTER_SPECIFIC" },
   { OID_BPC_CONNECT,               L"OID_BPC_CONNECT" },
   { OID_BPC_COMMIT,                L"OID_BPC_COMMIT" },
   { OID_BPC_DISCONNECT,            L"OID_BPC_DISCONNECT" },
   { OID_BPC_CONNECTION_ENABLE,     L"OID_BPC_CONNECTION_ENABLE" },
   { OID_BPC_POOL_RESERVE,          L"OID_BPC_POOL_RESERVE" },
   { OID_BPC_POOL_RETURN,           L"OID_BPC_POOL_RETURN" },
   { OID_BPC_FORCE_RECEIVE,         L"OID_BPC_FORCE_RECEIVE" },
   { OID_BPC_LAST,                  L"OID_BPC_LAST" },
   { OID_1394_LOCAL_NODE_INFO,      L"OID_1394_LOCAL_NODE_INFO" },
   { OID_1394_VC_INFO,              L"OID_1394_VC_INFO" },
   { OID_CO_ADD_PVC,                L"OID_CO_ADD_PVC" },
   { OID_CO_DELETE_PVC,             L"OID_CO_DELETE_PVC" },
   { OID_CO_GET_CALL_INFORMATION,   L"OID_CO_GET_CALL_INFORMATION" },
   { OID_CO_ADD_ADDRESS,            L"OID_CO_ADD_ADDRESS" },
   { OID_CO_DELETE_ADDRESS,         L"OID_CO_DELETE_ADDRESS" },
   { OID_CO_GET_ADDRESSES,          L"OID_CO_GET_ADDRESSES" },
   { OID_CO_ADDRESS_CHANGE,         L"OID_CO_ADDRESS_CHANGE" },
   { OID_CO_SIGNALING_ENABLED,      L"OID_CO_SIGNALING_ENABLED" },
   { OID_CO_SIGNALING_DISABLED,     L"OID_CO_SIGNALING_DISABLED" },
   { OID_CO_AF_CLOSE,               L"OID_CO_AF_CLOSE" },
   { OID_CO_TAPI_CM_CAPS,           L"OID_CO_TAPI_CM_CAPS" },
   { OID_CO_TAPI_LINE_CAPS,         L"OID_CO_TAPI_LINE_CAPS" },
   { OID_CO_TAPI_ADDRESS_CAPS,      L"OID_CO_TAPI_ADDRESS_CAPS" },
   { OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS,   L"OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS" },
   { OID_CO_TAPI_TRANSLATE_NDIS_CALLPARAMS,   L"OID_CO_TAPI_TRANSLATE_NDIS_CALLPARAMS" },
   { OID_CO_TAPI_TRANSLATE_TAPI_SAP,   L"OID_CO_TAPI_TRANSLATE_TAPI_SAP" },
   { OID_CO_TAPI_GET_CALL_DIAGNOSTICS,   L"OID_CO_TAPI_GET_CALL_DIAGNOSTICS" },
   { OID_CO_TAPI_REPORT_DIGITS,     L"OID_CO_TAPI_REPORT_DIGITS" },
   { OID_CO_TAPI_DONT_REPORT_DIGITS,   L"OID_CO_TAPI_DONT_REPORT_DIGITS" },
   { OID_PNP_CAPABILITIES,          L"OID_PNP_CAPABILITIES" },
   { OID_PNP_SET_POWER,             L"OID_PNP_SET_POWER" },
   { OID_PNP_QUERY_POWER,           L"OID_PNP_QUERY_POWER" },
   { OID_PNP_ADD_WAKE_UP_PATTERN,   L"OID_PNP_ADD_WAKE_UP_PATTERN" },
   { OID_PNP_REMOVE_WAKE_UP_PATTERN,   L"OID_PNP_REMOVE_WAKE_UP_PATTERN" },
   { OID_PNP_WAKE_UP_PATTERN_LIST,  L"OID_PNP_WAKE_UP_PATTERN_LIST" },
   { OID_PNP_ENABLE_WAKE_UP,        L"OID_PNP_ENABLE_WAKE_UP" },
   { OID_PNP_WAKE_UP_OK,            L"OID_PNP_WAKE_UP_OK" },
   { OID_PNP_WAKE_UP_ERROR,         L"OID_PNP_WAKE_UP_ERROR" },
   { OID_TCP_TASK_OFFLOAD,          L"OID_TCP_TASK_OFFLOAD" },
   { OID_TCP_TASK_IPSEC_ADD_SA,     L"OID_TCP_TASK_IPSEC_ADD_SA" },
   { OID_TCP_TASK_IPSEC_DELETE_SA,  L"OID_TCP_TASK_IPSEC_DELETE_SA" },
   { OID_TCP_SAN_SUPPORT,           L"OID_TCP_SAN_SUPPORT" },
   { OID_FFP_SUPPORT,               L"OID_FFP_SUPPORT" },
   { OID_FFP_FLUSH,                 L"OID_FFP_FLUSH" },
   { OID_FFP_CONTROL,               L"OID_FFP_CONTROL" },
   { OID_FFP_PARAMS,                L"OID_FFP_PARAMS" },
   { OID_FFP_DATA,                  L"OID_FFP_DATA" },
   { OID_FFP_DRIVER_STATS,          L"OID_FFP_DRIVER_STATS" },
   { OID_FFP_ADAPTER_STATS,         L"OID_FFP_ADAPTER_STATS" },
   { OID_QOS_TC_SUPPORTED,          L"OID_QOS_TC_SUPPORTED" },
   { OID_QOS_REMAINING_BANDWIDTH,   L"OID_QOS_REMAINING_BANDWIDTH" },
   { OID_QOS_ISSLOW_FLOW,           L"OID_QOS_ISSLOW_FLOW" },
   { OID_QOS_BESTEFFORT_BANDWIDTH,  L"OID_QOS_BESTEFFORT_BANDWIDTH" },
   { OID_QOS_LATENCY,               L"OID_QOS_LATENCY" },
   { OID_QOS_FLOW_IP_CONFORMING,    L"OID_QOS_FLOW_IP_CONFORMING" },
   { OID_QOS_FLOW_COUNT,            L"OID_QOS_FLOW_COUNT" },
   { OID_QOS_NON_BESTEFFORT_LIMIT,  L"OID_QOS_NON_BESTEFFORT_LIMIT" },
   { OID_QOS_SCHEDULING_PROFILES_SUPPORTED,   L"OID_QOS_SCHEDULING_PROFILES_SUPPORTED" },
   { OID_QOS_CURRENT_SCHEDULING_PROFILE,   L"OID_QOS_CURRENT_SCHEDULING_PROFILE" },
   { OID_QOS_TIMER_RESOLUTION,      L"OID_QOS_TIMER_RESOLUTION" },
   { OID_QOS_STATISTICS_BUFFER,     L"OID_QOS_STATISTICS_BUFFER" },
   { OID_QOS_HIERARCHY_CLASS,       L"OID_QOS_HIERARCHY_CLASS" },
   { OID_QOS_FLOW_MODE,             L"OID_QOS_FLOW_MODE" },
   { OID_QOS_ISSLOW_FRAGMENT_SIZE,  L"OID_QOS_ISSLOW_FRAGMENT_SIZE" },
   { OID_QOS_FLOW_IP_NONCONFORMING, L"OID_QOS_FLOW_IP_NONCONFORMING" },
   { OID_QOS_FLOW_8021P_CONFORMING, L"OID_QOS_FLOW_8021P_CONFORMING" },
   { OID_QOS_FLOW_8021P_NONCONFORMING,   L"OID_QOS_FLOW_8021P_NONCONFORMING" },
   { OID_QOS_ENABLE_AVG_STATS,      L"OID_QOS_ENABLE_AVG_STATS" },
   { OID_QOS_ENABLE_WINDOW_ADJUSTMENT,   L"OID_QOS_ENABLE_WINDOW_ADJUSTMENT" },
//   { OID_INDICATION_REQUEST_ENABLE, L"OID_INDICATION_REQUEST_ENABLE" },
//   { OID_INDICATION_REQUEST_CANCEL, L"OID_INDICATION_REQUEST_CANCEL" },

#ifdef NATIVE_WIFI
   // windot11.h
   // 101 Oids found
   { OID_DOT11_NDIS_START,          L"OID_DOT11_NDIS_START" },
   { OID_DOT11_OFFLOAD_CAPABILITY,  L"OID_DOT11_OFFLOAD_CAPABILITY" },
   { OID_DOT11_CURRENT_OFFLOAD_CAPABILITY,   L"OID_DOT11_CURRENT_OFFLOAD_CAPABILITY" },
   { OID_DOT11_WEP_OFFLOAD,         L"OID_DOT11_WEP_OFFLOAD" },
   { OID_DOT11_WEP_UPLOAD,          L"OID_DOT11_WEP_UPLOAD" },
   { OID_DOT11_DEFAULT_WEP_OFFLOAD, L"OID_DOT11_DEFAULT_WEP_OFFLOAD" },
   { OID_DOT11_DEFAULT_WEP_UPLOAD,  L"OID_DOT11_DEFAULT_WEP_UPLOAD" },
   { OID_DOT11_MPDU_MAX_LENGTH,     L"OID_DOT11_MPDU_MAX_LENGTH" },
   { OID_DOT11_OPERATION_MODE_CAPABILITY,   L"OID_DOT11_OPERATION_MODE_CAPABILITY" },
   { OID_DOT11_CURRENT_OPERATION_MODE,   L"OID_DOT11_CURRENT_OPERATION_MODE" },
   { OID_DOT11_CURRENT_PACKET_FILTER,   L"OID_DOT11_CURRENT_PACKET_FILTER" },
   { OID_DOT11_ATIM_WINDOW,         L"OID_DOT11_ATIM_WINDOW" },
   { OID_DOT11_SCAN_REQUEST,        L"OID_DOT11_SCAN_REQUEST" },
   { OID_DOT11_CURRENT_PHY_TYPE,    L"OID_DOT11_CURRENT_PHY_TYPE" },
   { OID_DOT11_JOIN_REQUEST,        L"OID_DOT11_JOIN_REQUEST" },
   { OID_DOT11_START_REQUEST,       L"OID_DOT11_START_REQUEST" },
   { OID_DOT11_UPDATE_IE,           L"OID_DOT11_UPDATE_IE" },
   { OID_DOT11_RESET_REQUEST,       L"OID_DOT11_RESET_REQUEST" },
   { OID_DOT11_NIC_POWER_STATE,     L"OID_DOT11_NIC_POWER_STATE" },
   { OID_DOT11_OPTIONAL_CAPABILITY, L"OID_DOT11_OPTIONAL_CAPABILITY" },
   { OID_DOT11_CURRENT_OPTIONAL_CAPABILITY,   L"OID_DOT11_CURRENT_OPTIONAL_CAPABILITY" },
   { OID_DOT11_STATION_ID,          L"OID_DOT11_STATION_ID" },
   { OID_DOT11_MEDIUM_OCCUPANCY_LIMIT,   L"OID_DOT11_MEDIUM_OCCUPANCY_LIMIT" },
   { OID_DOT11_CF_POLLABLE,         L"OID_DOT11_CF_POLLABLE" },
   { OID_DOT11_CFP_PERIOD,          L"OID_DOT11_CFP_PERIOD" },
   { OID_DOT11_CFP_MAX_DURATION,    L"OID_DOT11_CFP_MAX_DURATION" },
   { OID_DOT11_POWER_MGMT_MODE,     L"OID_DOT11_POWER_MGMT_MODE" },
   { OID_DOT11_OPERATIONAL_RATE_SET,   L"OID_DOT11_OPERATIONAL_RATE_SET" },
   { OID_DOT11_BEACON_PERIOD,       L"OID_DOT11_BEACON_PERIOD" },
   { OID_DOT11_DTIM_PERIOD,         L"OID_DOT11_DTIM_PERIOD" },
   { OID_DOT11_WEP_ICV_ERROR_COUNT, L"OID_DOT11_WEP_ICV_ERROR_COUNT" },
   { OID_DOT11_MAC_ADDRESS,         L"OID_DOT11_MAC_ADDRESS" },
   { OID_DOT11_RTS_THRESHOLD,       L"OID_DOT11_RTS_THRESHOLD" },
   { OID_DOT11_SHORT_RETRY_LIMIT,   L"OID_DOT11_SHORT_RETRY_LIMIT" },
   { OID_DOT11_LONG_RETRY_LIMIT,    L"OID_DOT11_LONG_RETRY_LIMIT" },
   { OID_DOT11_FRAGMENTATION_THRESHOLD,   L"OID_DOT11_FRAGMENTATION_THRESHOLD" },
   { OID_DOT11_MAX_TRANSMIT_MSDU_LIFETIME,   L"OID_DOT11_MAX_TRANSMIT_MSDU_LIFETIME" },
   { OID_DOT11_MAX_RECEIVE_LIFETIME,   L"OID_DOT11_MAX_RECEIVE_LIFETIME" },
   { OID_DOT11_COUNTERS_ENTRY,      L"OID_DOT11_COUNTERS_ENTRY" },
   { OID_DOT11_SUPPORTED_PHY_TYPES, L"OID_DOT11_SUPPORTED_PHY_TYPES" },
   { OID_DOT11_CURRENT_REG_DOMAIN,  L"OID_DOT11_CURRENT_REG_DOMAIN" },
   { OID_DOT11_TEMP_TYPE,           L"OID_DOT11_TEMP_TYPE" },
   { OID_DOT11_CURRENT_TX_ANTENNA,  L"OID_DOT11_CURRENT_TX_ANTENNA" },
   { OID_DOT11_DIVERSITY_SUPPORT,   L"OID_DOT11_DIVERSITY_SUPPORT" },
   { OID_DOT11_CURRENT_RX_ANTENNA,  L"OID_DOT11_CURRENT_RX_ANTENNA" },
   { OID_DOT11_SUPPORTED_POWER_LEVELS,   L"OID_DOT11_SUPPORTED_POWER_LEVELS" },
   { OID_DOT11_CURRENT_TX_POWER_LEVEL,   L"OID_DOT11_CURRENT_TX_POWER_LEVEL" },
   { OID_DOT11_HOP_TIME,            L"OID_DOT11_HOP_TIME" },
   { OID_DOT11_CURRENT_CHANNEL_NUMBER,   L"OID_DOT11_CURRENT_CHANNEL_NUMBER" },
   { OID_DOT11_MAX_DWELL_TIME,      L"OID_DOT11_MAX_DWELL_TIME" },
   { OID_DOT11_CURRENT_DWELL_TIME,  L"OID_DOT11_CURRENT_DWELL_TIME" },
   { OID_DOT11_CURRENT_SET,         L"OID_DOT11_CURRENT_SET" },
   { OID_DOT11_CURRENT_PATTERN,     L"OID_DOT11_CURRENT_PATTERN" },
   { OID_DOT11_CURRENT_INDEX,       L"OID_DOT11_CURRENT_INDEX" },
   { OID_DOT11_CURRENT_CHANNEL,     L"OID_DOT11_CURRENT_CHANNEL" },
   { OID_DOT11_CCA_MODE_SUPPORTED,  L"OID_DOT11_CCA_MODE_SUPPORTED" },
   { OID_DOT11_CURRENT_CCA_MODE,    L"OID_DOT11_CURRENT_CCA_MODE" },
   { OID_DOT11_ED_THRESHOLD,        L"OID_DOT11_ED_THRESHOLD" },
   { OID_DOT11_CCA_WATCHDOG_TIMER_MAX,   L"OID_DOT11_CCA_WATCHDOG_TIMER_MAX" },
   { OID_DOT11_CCA_WATCHDOG_COUNT_MAX,   L"OID_DOT11_CCA_WATCHDOG_COUNT_MAX" },
   { OID_DOT11_CCA_WATCHDOG_TIMER_MIN,   L"OID_DOT11_CCA_WATCHDOG_TIMER_MIN" },
   { OID_DOT11_CCA_WATCHDOG_COUNT_MIN,   L"OID_DOT11_CCA_WATCHDOG_COUNT_MIN" },
   { OID_DOT11_REG_DOMAINS_SUPPORT_VALUE,   L"OID_DOT11_REG_DOMAINS_SUPPORT_VALUE" },
   { OID_DOT11_SUPPORTED_TX_ANTENNA,   L"OID_DOT11_SUPPORTED_TX_ANTENNA" },
   { OID_DOT11_SUPPORTED_RX_ANTENNA,   L"OID_DOT11_SUPPORTED_RX_ANTENNA" },
   { OID_DOT11_DIVERSITY_SELECTION_RX,   L"OID_DOT11_DIVERSITY_SELECTION_RX" },
   { OID_DOT11_SUPPORTED_DATA_RATES_VALUE,   L"OID_DOT11_SUPPORTED_DATA_RATES_VALUE" },
   { OID_DOT11_CURRENT_FREQUENCY,   L"OID_DOT11_CURRENT_FREQUENCY" },
   { OID_DOT11_TI_THRESHOLD,        L"OID_DOT11_TI_THRESHOLD" },
   { OID_DOT11_FREQUENCY_BANDS_SUPPORTED,   L"OID_DOT11_FREQUENCY_BANDS_SUPPORTED" },
   { OID_DOT11_SHORT_PREAMBLE_OPTION_IMPLEMENTED,   L"OID_DOT11_SHORT_PREAMBLE_OPTION_IMPLEMENTED" },
   { OID_DOT11_PBCC_OPTION_IMPLEMENTED,   L"OID_DOT11_PBCC_OPTION_IMPLEMENTED" },
   { OID_DOT11_CHANNEL_AGILITY_PRESENT,   L"OID_DOT11_CHANNEL_AGILITY_PRESENT" },
   { OID_DOT11_CHANNEL_AGILITY_ENABLED,   L"OID_DOT11_CHANNEL_AGILITY_ENABLED" },
   { OID_DOT11_HR_CCA_MODE_SUPPORTED,   L"OID_DOT11_HR_CCA_MODE_SUPPORTED" },
   { OID_DOT11_MULTI_DOMAIN_CAPABILITY_IMPLEMENTED,   L"OID_DOT11_MULTI_DOMAIN_CAPABILITY_IMPLEMENTED" },
   { OID_DOT11_MULTI_DOMAIN_CAPABILITY_ENABLED,   L"OID_DOT11_MULTI_DOMAIN_CAPABILITY_ENABLED" },
   { OID_DOT11_COUNTRY_STRING,      L"OID_DOT11_COUNTRY_STRING" },
   { OID_DOT11_MULTI_DOMAIN_CAPABILITY,   L"OID_DOT11_MULTI_DOMAIN_CAPABILITY" },
   { OID_DOT11_EHCC_PRIME_RADIX,    L"OID_DOT11_EHCC_PRIME_RADIX" },
   { OID_DOT11_EHCC_NUMBER_OF_CHANNELS_FAMILY_INDEX,   L"OID_DOT11_EHCC_NUMBER_OF_CHANNELS_FAMILY_INDEX" },
   { OID_DOT11_EHCC_CAPABILITY_IMPLEMENTED,   L"OID_DOT11_EHCC_CAPABILITY_IMPLEMENTED" },
   { OID_DOT11_EHCC_CAPABILITY_ENABLED,   L"OID_DOT11_EHCC_CAPABILITY_ENABLED" },
   { OID_DOT11_HOP_ALGORITHM_ADOPTED,   L"OID_DOT11_HOP_ALGORITHM_ADOPTED" },
   { OID_DOT11_RANDOM_TABLE_FLAG,   L"OID_DOT11_RANDOM_TABLE_FLAG" },
   { OID_DOT11_NUMBER_OF_HOPPING_SETS,   L"OID_DOT11_NUMBER_OF_HOPPING_SETS" },
   { OID_DOT11_HOP_MODULUS,         L"OID_DOT11_HOP_MODULUS" },
   { OID_DOT11_HOP_OFFSET,          L"OID_DOT11_HOP_OFFSET" },
   { OID_DOT11_HOPPING_PATTERN,     L"OID_DOT11_HOPPING_PATTERN" },
   { OID_DOT11_RANDOM_TABLE_FIELD_NUMBER,   L"OID_DOT11_RANDOM_TABLE_FIELD_NUMBER" },
   { OID_DOT11_WPA_TSC,             L"OID_DOT11_WPA_TSC" },
   { OID_DOT11_RSSI_RANGE,          L"OID_DOT11_RSSI_RANGE" },
   { OID_DOT11_RF_USAGE,            L"OID_DOT11_RF_USAGE" },
   { OID_DOT11_NIC_SPECIFIC_EXTENSION,   L"OID_DOT11_NIC_SPECIFIC_EXTENSION" },
   { OID_DOT11_AP_JOIN_REQUEST,     L"OID_DOT11_AP_JOIN_REQUEST" },
   { OID_DOT11_PRIVATE_OIDS_START,  L"OID_DOT11_PRIVATE_OIDS_START" },
   { OID_DOT11_MAXIMUM_LOOKAHEAD,   L"OID_DOT11_MAXIMUM_LOOKAHEAD" },
   { OID_DOT11_CURRENT_LOOKAHEAD,   L"OID_DOT11_CURRENT_LOOKAHEAD" },
   { OID_DOT11_CURRENT_ADDRESS,     L"OID_DOT11_CURRENT_ADDRESS" },
   { OID_DOT11_PERMANENT_ADDRESS,   L"OID_DOT11_PERMANENT_ADDRESS" },
   { OID_DOT11_MULTICAST_LIST,      L"OID_DOT11_MULTICAST_LIST" },
#endif

   { 0, NULL }
};

WCHAR* szUnknownOid = L"OID_unknown";


WCHAR*
OidString
(
   IN NDIS_OID Oid
)
{
    for(POID_TABLE pOidTable = g_OidTable; pOidTable->szOid; pOidTable++)
    {
        if(pOidTable->Oid == Oid)
            return pOidTable->szOid;
    }
    return szUnknownOid;
}
	