//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
////////////////////////////////////////////////////////////////////////////////
//
//  TUXTEST TUX DLL
//  Copyright (c) Microsoft Corporation
//
//  Module: HEBREW.h
//          
//
//  Revision History:changed #define values:
//
////////////////////////////////////////////////////////////////////////////////

#include "..\kbddef.h"

// ****************************************************
// Hebrew keyboard
//
//  Num  VK1   VK2    Num   Unicode
testSequence KBDTests_Hebrew[] = 
{
    // With CAPSLOCK OFF
    // Without VK_SHIFT
    {1, {0x20, 0x00}, 1,    0x0020}, // Space key
    //  {1, {0x1B, 0x00}, 1,    0x001B}, // Esc key
    {1, {0x08, 0x00}, 1,    0x0008}, // BackSpace key
    {1, {0x0D, 0x00}, 1,    0x000D}, // Enter key
    {1, {0x09, 0x00}, 1,    0x0009}, // Tab key
    /* Keys `1234567890-= */
    {1, {0xC0, 0x00}, 1,    0x003B},      
    {1, {0x31, 0x00}, 1,    0x0031},      
    {1, {0x32, 0x00}, 1,    0x0032},      
    {1, {0x33, 0x00}, 1,    0x0033},      
    {1, {0x34, 0x00}, 1,    0x0034},      
    {1, {0x35, 0x00}, 1,    0x0035},      
    {1, {0x36, 0x00}, 1,    0x0036},      
    {1, {0x37, 0x00}, 1,    0x0037},      
    {1, {0x38, 0x00}, 1,    0x0038},      
    {1, {0x39, 0x00}, 1,    0X0039},      
    {1, {0x30, 0x00}, 1,    0x0030},      
    {1, {0xBD, 0x00}, 1,    0x002D},      
    {1, {0xBB, 0x00}, 1,    0x003D},      
    /* Keys qwertyuiop[]\ */
    {1, {0x51, 0x00}, 1,    0x002F},            
    {1, {0x57, 0x00}, 1,    0x0027},            
    {1, {0x45, 0x00}, 1,    0x05E7},            
    {1, {0x52, 0x00}, 1,    0x05E8},            
    {1, {0x54, 0x00}, 1,    0x05D0},            
    {1, {0x59, 0x00}, 1,    0x05D8},            
    {1, {0x55, 0x00}, 1,    0x05D5},            
    {1, {0x49, 0x00}, 1,    0x05DF},            
    {1, {0x4F, 0x00}, 1,    0x05DD},            
    {1, {0x50, 0x00}, 1,    0x05E4},            
    {1, {0xDB, 0x00}, 1,    0x005D},            
    {1, {0xDD, 0x00}, 1,    0x005B},            
    {1, {0xDC, 0x00}, 1,    0x005C},            
    /* Keys asdfghjkl;' */
    {1, {0x41, 0x00}, 1,    0x05E9},            
    {1, {0x53, 0x00}, 1,    0x05D3},            
    {1, {0x44, 0x00}, 1,    0x05D2},            
    {1, {0x46, 0x00}, 1,    0x05DB},            
    {1, {0x47, 0x00}, 1,    0x05E2},            
    {1, {0x48, 0x00}, 1,    0x05D9},            
    {1, {0x4A, 0x00}, 1,    0x05D7},            
    {1, {0x4B, 0x00}, 1,    0x05DC},            
    {1, {0x4C, 0x00}, 1,    0x05DA},            
    {1, {0xBA, 0x00}, 1,    0x05E3},      
    {1, {0xDE, 0x00}, 1,    0x002C},      
    /* Keys zxcvbnm,./ */
    {1, {0x5A, 0x00}, 1,    0x05D6},          
    {1, {0x58, 0x00}, 1,    0x05E1},            
    {1, {0x43, 0x00}, 1,    0x05D1},            
    {1, {0x56, 0x00}, 1,    0x05D4},
    {1, {0x42, 0x00}, 1,    0x05E0},            
    {1, {0x4E, 0x00}, 1,    0x05DE},            
    {1, {0x4D, 0x00}, 1,    0x05E6},      
    {1, {0xBC, 0x00}, 1,    0x05EA},
    {1, {0xBE, 0x00}, 1,    0x05E5},      
    {1, {0xBF, 0x00}, 1,    0x002E},
    // With VK_SHIFT
    /* Keys `1234567890-= */
    {2, {0x10, 0xC0}, 1,    0x007E},     
    {2, {0x10, 0x31}, 1,    0x0021},      
    {2, {0x10, 0x32}, 1,    0x0040},     
    {2, {0x10, 0x33}, 1,    0x0023},      
    {2, {0x10, 0x34}, 1,    0x0024},      
    {2, {0x10, 0x35}, 1,    0x0025},      
    {2, {0x10, 0x36}, 1,    0x005E},     
    {2, {0x10, 0x37}, 1,    0x0026},     
    {2, {0x10, 0x38}, 1,    0x002A},     
    {2, {0x10, 0x39}, 1,    0x0029},     
    {2, {0x10, 0x30}, 1,    0x0028},      
    {2, {0x10, 0xBD}, 1,    0x005F},     
    {2, {0x10, 0xBB}, 1,    0x002B},      
    /* Keys qwertyuiop[]\ */
    {2, {0x10, 0x51}, 1,    0x0051},            
    {2, {0x10, 0x57}, 1,    0x0057},            
    {2, {0x10, 0x45}, 1,    0x0045},        
    {2, {0x10, 0x52}, 1,    0x0052},            
    {2, {0x10, 0x54}, 1,    0x0054},
    {2, {0x10, 0x59}, 1,    0x0059},            
    {2, {0x10, 0x55}, 1,    0x0055},            
    {2, {0x10, 0x49}, 1,    0x0049},            
    {2, {0x10, 0x4F}, 1,    0x004F},            
    {2, {0x10, 0x50}, 1,    0x0050},            
    {2, {0x10, 0xDB}, 1,    0x007D},            
    {2, {0x10, 0xDD}, 1,    0x007B},        
    {2, {0x10, 0xDC}, 1,    0x007C},            
    /* Keys asdfhjkl;' */
    {2, {0x10, 0x41}, 1,    0x0041},            
    {2, {0x10, 0x53}, 1,    0x0053},            
    {2, {0x10, 0x44}, 1,    0x0044},            
    {2, {0x10, 0x46}, 1,    0x0046},
    {2, {0x10, 0x47}, 1,    0x0047},            
    {2, {0x10, 0x48}, 1,    0x0048},            
    {2, {0x10, 0x4A}, 1,    0x004A},            
    {2, {0x10, 0x4B}, 1,    0x004B},            
    {2, {0x10, 0x4C}, 1,    0x004C},            
    {2, {0x10, 0xBA}, 1,    0x003A},    
    {2, {0x10, 0xDE}, 1,    0x0022},     
    /* Keys zxcvbnm,./ */
    {2, {0x10, 0x5A}, 1,    0x005A},          
    {2, {0x10, 0x58}, 1,    0x0058},            
    {2, {0x10, 0x43}, 1,    0x0043},            
    {2, {0x10, 0x56}, 1,    0x0056},            
    {2, {0x10, 0x42}, 1,    0x0042},
    {2, {0x10, 0x4E}, 1,    0x004E},            
    {2, {0x10, 0x4D}, 1,    0x004D},            
    {2, {0x10, 0xBC}, 1,    0x003E},     
    {2, {0x10, 0xBE}, 1,    0x003C},      
    {2, {0x10, 0xBF}, 1,    0x003F},
    // Control chars (with VK_CONTROL)
    // Row ZXCV
    {2, {0x11, 90}, 1, 0x1A},           // Ctrl Z
    {2, {0x11, 88}, 1, 0x18},           // Ctrl X
    {2, {0x11, 67}, 1, 0x03},           // Ctrl C
    {2, {0x11, 86}, 1, 0x16},           // Ctrl V
    {2, {0x11, 66}, 1, 0x02},           // Ctrl B
    {2, {0x11, 78}, 1, 0x0E},           // Ctrl N
    {2, {0x11, 77}, 1, 0x0D},           // Ctrl M
    //Row ASDF
    {2, {0x11, 65}, 1, 0x01},           // Ctrl A
    {2, {0x11, 83}, 1, 0x13},           // Ctrl S
    {2, {0x11, 68}, 1, 0x04},           // Ctrl D
    {2, {0x11, 70}, 1, 0x06},           // Ctrl F
    {2, {0x11, 71}, 1, 0x07},           // Ctrl G
    {2, {0x11, 72}, 1, 0x08},           // Ctrl H
    {2, {0x11, 74}, 1, 0x0A},           // Ctrl J
    {2, {0x11, 75}, 1, 0x0B},           // Ctrl K
    {2, {0x11, 76}, 1, 0x0C},           // Ctrl L
    // Row QWER
    {2, {0x11, 81}, 1, 0x11},           // Ctrl Q
    {2, {0x11, 87}, 1, 0x17},           // Ctrl W
    {2, {0x11, 69}, 1, 0x05},           // Ctrl E
    {2, {0x11, 82}, 1, 0x12},           // Ctrl R
    {2, {0x11, 84}, 1, 0x14},           // Ctrl T
    {2, {0x11, 89}, 1, 0x19},           // Ctrl Y
    {2, {0x11, 85}, 1, 0x15},           // Ctrl U
    {2, {0x11, 73}, 1, 0x09},           // Ctrl I
    {2, {0x11, 79}, 1, 0x0F},           // Ctrl O
    {2, {0x11, 80}, 1, 0x10},           // Ctrl P
    // With ALT-Gr key (VK_CONTROL, VK_MENU)
    {3, {0x0011, 0x0012, 0x0034}, 1, 0x20AA}, // Ctrl + Alt + 4
    {3, {0x0011, 0x0012, 0x0045}, 1, 0x20AC}, // Ctrl + Alt + E
    {3, {0x0011, 0x0012, 0x0055}, 1, 0x05F0}, // Ctrl + Alt + U
    {3, {0x0011, 0x0012, 0x0048}, 1, 0x05F2}, // Ctrl + Alt + H
    {3, {0x0011, 0x0012, 0x004A}, 1, 0x05F1}, // Ctrl + Alt + J
    // Keystrokes that do not generate WM_CHARs
    /* Keys `123567890= */
    {3, {0x0011, 0x0012, 0xC0}, 0, 0},
    {3, {0x0011, 0x0012, 0x31}, 0, 0},
    {3, {0x0011, 0x0012, 0x32}, 0, 0},
    {3, {0x0011, 0x0012, 0x33}, 0, 0},
    {3, {0x0011, 0x0012, 0x35}, 0, 0},
    {3, {0x0011, 0x0012, 0x36}, 0, 0},
    {3, {0x0011, 0x0012, 0x37}, 0, 0},
    {3, {0x0011, 0x0012, 0x38}, 0, 0},
    {3, {0x0011, 0x0012, 0x39}, 0, 0},
    {3, {0x0011, 0x0012, 0x30}, 0, 0},
    {3, {0x0011, 0x0012, 0xBB}, 0, 0},
    /* Keys qwrtyiop[]\ */
    {3, {0x0011, 0x0012, 0x51}, 0, 0},
    {3, {0x0011, 0x0012, 0x57}, 0, 0},
    {3, {0x0011, 0x0012, 0x52}, 0, 0},
    {3, {0x0011, 0x0012, 0x54}, 0, 0},
    {3, {0x0011, 0x0012, 0x59}, 0, 0},
    {3, {0x0011, 0x0012, 0x49}, 0, 0},
    {3, {0x0011, 0x0012, 0x4F}, 0, 0},
    {3, {0x0011, 0x0012, 0x50}, 0, 0},
    {3, {0x0011, 0x0012, 0xDB}, 0, 0},
    {3, {0x0011, 0x0012, 0xDD}, 0, 0},
    {3, {0x0011, 0x0012, 0xDC}, 0, 0},
    /* Keys asdfgkl;' */
    {3, {0x0011, 0x0012, 0x41}, 0, 0},
    {3, {0x0011, 0x0012, 0x53}, 0, 0},
    {3, {0x0011, 0x0012, 0x44}, 0, 0},
    {3, {0x0011, 0x0012, 0x46}, 0, 0},
    {3, {0x0011, 0x0012, 0x47}, 0, 0},
    {3, {0x0011, 0x0012, 0x4B}, 0, 0},
    {3, {0x0011, 0x0012, 0x4C}, 0, 0},
    {3, {0x0011, 0x0012, 0xBA}, 0, 0},
    {3, {0x0011, 0x0012, 0xDE}, 0, 0},
    /* Keys zxcvbnm,./ */
    {3, {0x0011, 0x0012, 0x5A}, 0, 0},
    {3, {0x0011, 0x0012, 0x58}, 0, 0},
    {3, {0x0011, 0x0012, 0x43}, 0, 0},
    {3, {0x0011, 0x0012, 0x56}, 0, 0},
    {3, {0x0011, 0x0012, 0x42}, 0, 0},
    {3, {0x0011, 0x0012, 0x4E}, 0, 0},
    {3, {0x0011, 0x0012, 0x4D}, 0, 0},
    {3, {0x0011, 0x0012, 0xBC}, 0, 0},
    {3, {0x0011, 0x0012, 0xBE}, 0, 0},
    {3, {0x0011, 0x0012, 0xBF}, 0, 0},

    // Turn CAPSLOCK ON
    {STATE_CAPSLOCK, {0x10, 0x14}, 0, 0},

    // With CAPSLOCK ON
    // Without VK_SHIFT
    {1, {0x20, 0x00}, 1,    0x0020}, // Space key
    //  {1, {0x1B, 0x00}, 1,    0x001B}, // Esc key
    {1, {0x08, 0x00}, 1,    0x0008}, // BackSpace key
    {1, {0x0D, 0x00}, 1,    0x000D}, // Enter key
    {1, {0x09, 0x00}, 1,    0x0009}, // Tab key
    /* Keys `1234567890-= */
    {1, {0xC0, 0x00}, 1,    0x003B},      
    {1, {0x31, 0x00}, 1,    0x0031},      
    {1, {0x32, 0x00}, 1,    0x0032},      
    {1, {0x33, 0x00}, 1,    0x0033},      
    {1, {0x34, 0x00}, 1,    0x0034},      
    {1, {0x35, 0x00}, 1,    0x0035},      
    {1, {0x36, 0x00}, 1,    0x0036},      
    {1, {0x37, 0x00}, 1,    0x0037},      
    {1, {0x38, 0x00}, 1,    0x0038},      
    {1, {0x39, 0x00}, 1,    0X0039},      
    {1, {0x30, 0x00}, 1,    0x0030},      
    {1, {0xBD, 0x00}, 1,    0x002D},      
    {1, {0xBB, 0x00}, 1,    0x003D},      
    /* Keys qwertyuiop[]\ */
    {1, {0x51, 0x00}, 1,    0x0051},            
    {1, {0x57, 0x00}, 1,    0x0057},            
    {1, {0x45, 0x00}, 1,    0x0045},            
    {1, {0x52, 0x00}, 1,    0x0052},            
    {1, {0x54, 0x00}, 1,    0x0054},            
    {1, {0x59, 0x00}, 1,    0x0059},            
    {1, {0x55, 0x00}, 1,    0x0055},            
    {1, {0x49, 0x00}, 1,    0x0049},            
    {1, {0x4F, 0x00}, 1,    0x004F},            
    {1, {0x50, 0x00}, 1,    0x0050},            
    {1, {0xDB, 0x00}, 1,    0x005B},            
    {1, {0xDD, 0x00}, 1,    0x005D},            
    {1, {0xDC, 0x00}, 1,    0x005C},            
    /* Keys asdfghjkl;' */
    {1, {0x41, 0x00}, 1,    0x0041},            
    {1, {0x53, 0x00}, 1,    0x0053},            
    {1, {0x44, 0x00}, 1,    0x0044},            
    {1, {0x46, 0x00}, 1,    0x0046},            
    {1, {0x47, 0x00}, 1,    0x0047},            
    {1, {0x48, 0x00}, 1,    0x0048},            
    {1, {0x4A, 0x00}, 1,    0x004A},            
    {1, {0x4B, 0x00}, 1,    0x004B},            
    {1, {0x4C, 0x00}, 1,    0x004C},            
    {1, {0xBA, 0x00}, 1,    0x003B},      
    {1, {0xDE, 0x00}, 1,    0x0027},      
    /* Keys zxcvbnm,./ */
    {1, {0x5A, 0x00}, 1,    0x005A},          
    {1, {0x58, 0x00}, 1,    0x0058},            
    {1, {0x43, 0x00}, 1,    0x0043},            
    {1, {0x56, 0x00}, 1,    0x0056},
    {1, {0x42, 0x00}, 1,    0x0042},            
    {1, {0x4E, 0x00}, 1,    0x004E},
    {1, {0x4D, 0x00}, 1,    0x004D},      
    {1, {0xBC, 0x00}, 1,    0x002C},
    {1, {0xBE, 0x00}, 1,    0x002E},      
    {1, {0xBF, 0x00}, 1,    0x002F},
    // With VK_SHIFT
    /* Keys `1234567890-= */
    {2, {0x10, 0xC0}, 1,    0x05B0},     
    {2, {0x10, 0x31}, 1,    0x05B1},      
    {2, {0x10, 0x32}, 1,    0x05B2},     
    {2, {0x10, 0x33}, 1,    0x05B3},      
    {2, {0x10, 0x34}, 1,    0x05B4},      
    {2, {0x10, 0x35}, 1,    0x05B5},      
    {2, {0x10, 0x36}, 1,    0x05B6},     
    {2, {0x10, 0x37}, 1,    0x05B7},     
    {2, {0x10, 0x38}, 1,    0x05B8},     
    {2, {0x10, 0x39}, 1,    0x05C2},     
    {2, {0x10, 0x30}, 1,    0x05C1},      
    {2, {0x10, 0xBD}, 1,    0x05B9},     
    {2, {0x10, 0xBB}, 1,    0x05BC},      
    /* Keys qwertyuiop[]\ */
    {2, {0x10, 0x51}, 1,    0x002F},            
    {2, {0x10, 0x57}, 1,    0x0027},            
    {2, {0x10, 0x45}, 1,    0x05E7},        
    {2, {0x10, 0x52}, 1,    0x05E8},            
    {2, {0x10, 0x54}, 1,    0x05D0},
    {2, {0x10, 0x59}, 1,    0x05D8},            
    {2, {0x10, 0x55}, 1,    0x05D5},            
    {2, {0x10, 0x49}, 1,    0x05DF},            
    {2, {0x10, 0x4F}, 1,    0x05DD},            
    {2, {0x10, 0x50}, 1,    0x05E4},            
    {2, {0x10, 0xDB}, 1,    0x005D},            
    {2, {0x10, 0xDD}, 1,    0x005B},        
    {2, {0x10, 0xDC}, 1,    0x05BB},            
    /* Keys asdfhjkl;' */
    {2, {0x10, 0x41}, 1,    0x05E9},            
    {2, {0x10, 0x53}, 1,    0x05D3},            
    {2, {0x10, 0x44}, 1,    0x05D2},            
    {2, {0x10, 0x46}, 1,    0x05DB},
    {2, {0x10, 0x47}, 1,    0x05E2},            
    {2, {0x10, 0x48}, 1,    0x05D9},            
    {2, {0x10, 0x4A}, 1,    0x05D7},            
    {2, {0x10, 0x4B}, 1,    0x05DC},            
    {2, {0x10, 0x4C}, 1,    0x05DA},            
    {2, {0x10, 0xBA}, 1,    0x05E3},    
    {2, {0x10, 0xDE}, 1,    0x002C},     
    /* Keys zxcvbnm,./ */
    {2, {0x10, 0x5A}, 1,    0x05D6},          
    {2, {0x10, 0x58}, 1,    0x05E1},            
    {2, {0x10, 0x43}, 1,    0x05D1},            
    {2, {0x10, 0x56}, 1,    0x05D4},            
    {2, {0x10, 0x42}, 1,    0x05E0},
    {2, {0x10, 0x4E}, 1,    0x05DE},            
    {2, {0x10, 0x4D}, 1,    0x05E6},            
    {2, {0x10, 0xBC}, 1,    0x05EA},     
    {2, {0x10, 0xBE}, 1,    0x05E5},      
    {2, {0x10, 0xBF}, 1,    0x002E},
    // Control chars (with VK_CONTROL)
    // Row ZXCV
    {2, {0x11, 90}, 1, 0x1A},          // Ctrl Z
    {2, {0x11, 88}, 1, 0x18},           // Ctrl X
    {2, {0x11, 67}, 1, 0x03},           // Ctrl C
    {2, {0x11, 86}, 1, 0x16},           // Ctrl V
    {2, {0x11, 66}, 1, 0x02},           // Ctrl B
    {2, {0x11, 78}, 1, 0x0E},           // Ctrl N
    {2, {0x11, 77}, 1, 0x0D},           // Ctrl M
    //Row ASDF
    {2, {0x11, 65}, 1, 0x01},           // Ctrl A
    {2, {0x11, 83}, 1, 0x13},           // Ctrl S
    {2, {0x11, 68}, 1, 0x04},           // Ctrl D
    {2, {0x11, 70}, 1, 0x06},           // Ctrl F
    {2, {0x11, 71}, 1, 0x07},           // Ctrl G
    {2, {0x11, 72}, 1, 0x08},           // Ctrl H
    {2, {0x11, 74}, 1, 0x0A},           // Ctrl J
    {2, {0x11, 75}, 1, 0x0B},           // Ctrl K
    {2, {0x11, 76}, 1, 0x0C},           // Ctrl L
    // Row QWER
    {2, {0x11, 81}, 1, 0x11},           // Ctrl Q
    {2, {0x11, 87}, 1, 0x17},           // Ctrl W
    {2, {0x11, 69}, 1, 0x05},           // Ctrl E
    {2, {0x11, 82}, 1, 0x12},           // Ctrl R
    {2, {0x11, 84}, 1, 0x14},           // Ctrl T
    {2, {0x11, 89}, 1, 0x19},           // Ctrl Y
    {2, {0x11, 85}, 1, 0x15},           // Ctrl U
    {2, {0x11, 73}, 1, 0x09},           // Ctrl I
    {2, {0x11, 79}, 1, 0x0F},           // Ctrl O
    {2, {0x11, 80}, 1, 0x10},

    //Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14}, 0,  0},
}; // end Hebrew keyboard