//==============================================================================
// mpplayer.cpp
//
// Copyright (c) 2003, Ensemble Studios
//==============================================================================

// Includes
#include "multiplayercommon.h"
#include "mpplayer.h"
#include "client.h"

//==============================================================================
// Defines

//==============================================================================
// BMPPlayer::BMPPlayer
//==============================================================================
BMPPlayer::BMPPlayer( BClient *client ) : 
   mLoaded(false),
   mReadyToStart(false),
   mClient(client)
{
   BFATAL_ASSERT(client);
   mID = client->getID();
   mName = client->getName();
}

//==============================================================================
// BMPPlayer::~BMPPlayer
//==============================================================================
BMPPlayer::~BMPPlayer( void )
{ 
}

//==============================================================================
// BMPPlayer::getID
//==============================================================================
DWORD BMPPlayer::getID(void) const
{
   return(mID);
}

//==============================================================================
// BMPPlayer::getName
//==============================================================================
const BSimString& BMPPlayer::getName(void) const
{
   return(mName);
}

//==============================================================================
// BMPPlayer::reset
//==============================================================================
void BMPPlayer::reset(void)
{
   mReadyToStart = false;
   mLoaded = false;
}

//==============================================================================
// BMPPlayer::
//==============================================================================
void BMPPlayer::setLoaded(bool r) 
{
   mLoaded = r;
}

//==============================================================================
// BMPPlayer::
//==============================================================================
bool BMPPlayer::getLoaded(void) const 
{ 
   return(mLoaded); 
}

//==============================================================================
// BMPPlayer::
//==============================================================================
void BMPPlayer::setReadyToStart(bool r)
{
   mReadyToStart = r;
}

//==============================================================================
// BMPPlayer::
//==============================================================================
bool BMPPlayer::getReadyToStart(void) const
{
   return mReadyToStart;
}

//==============================================================================
// BMPPlayer::
//==============================================================================

//==============================================================================
// eof: mpplayer.cpp
//==============================================================================
