/********************************************************************
 *                                                   *
 * THIS FILE IS PART OF THE OggVorbis 'TREMOR' CODEC SOURCE CODE.   *
 *                                                                  *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis 'TREMOR' SOURCE CODE IS (C) COPYRIGHT 1994-2002    *
 * BY THE Xiph.Org FOUNDATION http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: window lookup tables

 ********************************************************************/
#include "ogg/os_types.h"

static float vwin256[128] = {
  0.0000591390F, 0.0005321979F, 0.0014780301F, 0.0028960636F, 
  0.0047854363F, 0.0071449926F, 0.0099732775F, 0.0132685298F, 
  0.0170286741F, 0.0212513119F, 0.0259337111F, 0.0310727950F, 
  0.0366651302F, 0.0427069140F, 0.0491939614F, 0.0561216907F, 
  0.0634851102F, 0.0712788035F, 0.0794969160F, 0.0881331402F, 
  0.0971807028F, 0.1066323515F, 0.1164803426F, 0.1267164297F, 
  0.1373318534F, 0.1483173323F, 0.1596630553F, 0.1713586755F, 
  0.1833933062F, 0.1957555184F, 0.2084333404F, 0.2214142599F, 
  0.2346852280F, 0.2482326664F, 0.2620424757F, 0.2761000481F, 
  0.2903902813F, 0.3048975959F, 0.3196059553F, 0.3344988887F, 
  0.3495595160F, 0.3647705766F, 0.3801144597F, 0.3955732382F, 
  0.4111287047F, 0.4267624093F, 0.4424557009F, 0.4581897696F, 
  0.4739456913F, 0.4897044744F, 0.5054471075F, 0.5211546088F, 
  0.5368080763F, 0.5523887395F, 0.5678780103F, 0.5832575361F, 
  0.5985092508F, 0.6136154277F, 0.6285587300F, 0.6433222619F, 
  0.6578896175F, 0.6722449294F, 0.6863729144F, 0.7002589187F, 
  0.7138889597F, 0.7272497662F, 0.7403288154F, 0.7531143679F, 
  0.7655954985F, 0.7777621249F, 0.7896050322F, 0.8011158947F, 
  0.8122872932F, 0.8231127294F, 0.8335866365F, 0.8437043850F, 
  0.8534622861F, 0.8628575905F, 0.8718884835F, 0.8805540765F, 
  0.8888543947F, 0.8967903616F, 0.9043637797F, 0.9115773078F, 
  0.9184344360F, 0.9249394562F, 0.9310974312F, 0.9369141608F, 
  0.9423961446F, 0.9475505439F, 0.9523851406F, 0.9569082947F, 
  0.9611289005F, 0.9650563408F, 0.9687004405F, 0.9720714191F, 
  0.9751798427F, 0.9780365753F, 0.9806527301F, 0.9830396204F, 
  0.9852087111F, 0.9871715701F, 0.9889398207F, 0.9905250941F, 
  0.9919389832F, 0.9931929973F, 0.9942985174F, 0.9952667537F, 
  0.9961087037F, 0.9968351119F, 0.9974564312F, 0.9979827858F, 
  0.9984239359F, 0.9987892441F, 0.9990876435F, 0.9993276081F, 
  0.9995171241F, 0.9996636648F, 0.9997741654F, 0.9998550016F, 
  0.9999119692F, 0.9999502656F, 0.9999744742F, 0.9999885497F, 
  0.9999958064F, 0.9999989077F, 0.9999998584F, 0.9999999983F, 
};

static float vwin512[256] = {
  0.0000147849F, 0.0001330607F, 0.0003695946F, 0.0007243509F, 
  0.0011972759F, 0.0017882983F, 0.0024973285F, 0.0033242588F, 
  0.0042689632F, 0.0053312973F, 0.0065110982F, 0.0078081841F, 
  0.0092223540F, 0.0107533880F, 0.0124010466F, 0.0141650703F, 
  0.0160451800F, 0.0180410758F, 0.0201524373F, 0.0223789233F, 
  0.0247201710F, 0.0271757958F, 0.0297453914F, 0.0324285286F, 
  0.0352247556F, 0.0381335972F, 0.0411545545F, 0.0442871045F, 
  0.0475306997F, 0.0508847676F, 0.0543487103F, 0.0579219038F, 
  0.0616036982F, 0.0653934164F, 0.0692903546F, 0.0732937809F, 
  0.0774029356F, 0.0816170305F, 0.0859352485F, 0.0903567428F, 
  0.0948806375F, 0.0995060259F, 0.1042319712F, 0.1090575056F, 
  0.1139816300F, 0.1190033137F, 0.1241214941F, 0.1293350764F, 
  0.1346429333F, 0.1400439046F, 0.1455367974F, 0.1511203852F, 
  0.1567934083F, 0.1625545735F, 0.1684025537F, 0.1743359881F, 
  0.1803534820F, 0.1864536069F, 0.1926349000F, 0.1988958650F, 
  0.2052349715F, 0.2116506555F, 0.2181413191F, 0.2247053313F, 
  0.2313410275F, 0.2380467105F, 0.2448206500F, 0.2516610835F, 
  0.2585662164F, 0.2655342226F, 0.2725632448F, 0.2796513950F, 
  0.2867967551F, 0.2939973773F, 0.3012512852F, 0.3085564739F, 
  0.3159109111F, 0.3233125375F, 0.3307592680F, 0.3382489922F, 
  0.3457795756F, 0.3533488602F, 0.3609546657F, 0.3685947904F, 
  0.3762670121F, 0.3839690896F, 0.3916987634F, 0.3994537572F, 
  0.4072317788F, 0.4150305215F, 0.4228476653F, 0.4306808783F, 
  0.4385278181F, 0.4463861329F, 0.4542534630F, 0.4621274424F, 
  0.4700057001F, 0.4778858615F, 0.4857655502F, 0.4936423891F, 
  0.5015140023F, 0.5093780165F, 0.5172320626F, 0.5250737772F, 
  0.5329008043F, 0.5407107971F, 0.5485014192F, 0.5562703465F, 
  0.5640152688F, 0.5717338914F, 0.5794239366F, 0.5870831457F, 
  0.5947092801F, 0.6023001235F, 0.6098534829F, 0.6173671907F, 
  0.6248391059F, 0.6322671161F, 0.6396491384F, 0.6469831217F, 
  0.6542670475F, 0.6614989319F, 0.6686768267F, 0.6757988210F, 
  0.6828630426F, 0.6898676592F, 0.6968108799F, 0.7036909564F, 
  0.7105061843F, 0.7172549043F, 0.7239355032F, 0.7305464154F, 
  0.7370861235F, 0.7435531598F, 0.7499461068F, 0.7562635986F, 
  0.7625043214F, 0.7686670148F, 0.7747504721F, 0.7807535410F, 
  0.7866751247F, 0.7925141825F, 0.7982697296F, 0.8039408387F, 
  0.8095266395F, 0.8150263196F, 0.8204391248F, 0.8257643590F, 
  0.8310013848F, 0.8361496236F, 0.8412085555F, 0.8461777194F, 
  0.8510567129F, 0.8558451924F, 0.8605428730F, 0.8651495278F, 
  0.8696649882F, 0.8740891432F, 0.8784219392F, 0.8826633797F, 
  0.8868135244F, 0.8908724888F, 0.8948404441F, 0.8987176157F, 
  0.9025042831F, 0.9062007791F, 0.9098074886F, 0.9133248482F, 
  0.9167533451F, 0.9200935163F, 0.9233459472F, 0.9265112712F, 
  0.9295901680F, 0.9325833632F, 0.9354916263F, 0.9383157705F, 
  0.9410566504F, 0.9437151618F, 0.9462922398F, 0.9487888576F, 
  0.9512060252F, 0.9535447882F, 0.9558062262F, 0.9579914516F, 
  0.9601016078F, 0.9621378683F, 0.9641014348F, 0.9659935361F, 
  0.9678154261F, 0.9695683830F, 0.9712537071F, 0.9728727198F, 
  0.9744267618F, 0.9759171916F, 0.9773453842F, 0.9787127293F, 
  0.9800206298F, 0.9812705006F, 0.9824637665F, 0.9836018613F, 
  0.9846862258F, 0.9857183066F, 0.9866995544F, 0.9876314227F, 
  0.9885153662F, 0.9893528393F, 0.9901452948F, 0.9908941823F, 
  0.9916009470F, 0.9922670279F, 0.9928938570F, 0.9934828574F, 
  0.9940354423F, 0.9945530133F, 0.9950369595F, 0.9954886562F, 
  0.9959094633F, 0.9963007242F, 0.9966637649F, 0.9969998925F, 
  0.9973103939F, 0.9975965351F, 0.9978595598F, 0.9981006885F, 
  0.9983211172F, 0.9985220166F, 0.9987045311F, 0.9988697776F, 
  0.9990188449F, 0.9991527924F, 0.9992726499F, 0.9993794157F, 
  0.9994740570F, 0.9995575079F, 0.9996306699F, 0.9996944099F, 
  0.9997495605F, 0.9997969190F, 0.9998372465F, 0.9998712678F, 
  0.9998996704F, 0.9999231041F, 0.9999421807F, 0.9999574732F, 
  0.9999695157F, 0.9999788026F, 0.9999857885F, 0.9999908879F, 
  0.9999944746F, 0.9999968817F, 0.9999984010F, 0.9999992833F, 
  0.9999997377F, 0.9999999317F, 0.9999999911F, 0.9999999999F, 
};

static float vwin1024[512] = {
  0.0000036962F, 0.0000332659F, 0.0000924041F, 0.0001811086F, 
  0.0002993761F, 0.0004472021F, 0.0006245811F, 0.0008315063F, 
  0.0010679699F, 0.0013339631F, 0.0016294757F, 0.0019544965F, 
  0.0023090133F, 0.0026930125F, 0.0031064797F, 0.0035493989F, 
  0.0040217533F, 0.0045235250F, 0.0050546946F, 0.0056152418F, 
  0.0062051451F, 0.0068243817F, 0.0074729278F, 0.0081507582F, 
  0.0088578466F, 0.0095941655F, 0.0103596863F, 0.0111543789F, 
  0.0119782122F, 0.0128311538F, 0.0137131701F, 0.0146242260F, 
  0.0155642855F, 0.0165333111F, 0.0175312640F, 0.0185581042F, 
  0.0196137903F, 0.0206982797F, 0.0218115284F, 0.0229534910F, 
  0.0241241208F, 0.0253233698F, 0.0265511886F, 0.0278075263F, 
  0.0290923308F, 0.0304055484F, 0.0317471241F, 0.0331170013F, 
  0.0345151222F, 0.0359414274F, 0.0373958560F, 0.0388783456F, 
  0.0403888325F, 0.0419272511F, 0.0434935347F, 0.0450876148F, 
  0.0467094213F, 0.0483588828F, 0.0500359261F, 0.0517404765F, 
  0.0534724575F, 0.0552317913F, 0.0570183983F, 0.0588321971F, 
  0.0606731048F, 0.0625410369F, 0.0644359070F, 0.0663576272F, 
  0.0683061077F, 0.0702812571F, 0.0722829821F, 0.0743111878F, 
  0.0763657775F, 0.0784466526F, 0.0805537129F, 0.0826868561F, 
  0.0848459782F, 0.0870309736F, 0.0892417345F, 0.0914781514F, 
  0.0937401128F, 0.0960275056F, 0.0983402145F, 0.1006781223F, 
  0.1030411101F, 0.1054290568F, 0.1078418397F, 0.1102793336F, 
  0.1127414119F, 0.1152279457F, 0.1177388042F, 0.1202738544F, 
  0.1228329618F, 0.1254159892F, 0.1280227980F, 0.1306532471F, 
  0.1333071937F, 0.1359844927F, 0.1386849970F, 0.1414085575F, 
  0.1441550230F, 0.1469242403F, 0.1497160539F, 0.1525303063F, 
  0.1553668381F, 0.1582254875F, 0.1611060909F, 0.1640084822F, 
  0.1669324936F, 0.1698779549F, 0.1728446939F, 0.1758325362F, 
  0.1788413055F, 0.1818708232F, 0.1849209084F, 0.1879913785F, 
  0.1910820485F, 0.1941927312F, 0.1973232376F, 0.2004733764F, 
  0.2036429541F, 0.2068317752F, 0.2100396421F, 0.2132663552F, 
  0.2165117125F, 0.2197755102F, 0.2230575422F, 0.2263576007F, 
  0.2296754753F, 0.2330109540F, 0.2363638225F, 0.2397338646F, 
  0.2431208619F, 0.2465245941F, 0.2499448389F, 0.2533813719F, 
  0.2568339669F, 0.2603023956F, 0.2637864277F, 0.2672858312F, 
  0.2708003718F, 0.2743298135F, 0.2778739186F, 0.2814324472F, 
  0.2850051576F, 0.2885918065F, 0.2921921485F, 0.2958059366F, 
  0.2994329219F, 0.3030728538F, 0.3067254799F, 0.3103905462F, 
  0.3140677969F, 0.3177569747F, 0.3214578205F, 0.3251700736F, 
  0.3288934718F, 0.3326277513F, 0.3363726468F, 0.3401278914F, 
  0.3438932168F, 0.3476683533F, 0.3514530297F, 0.3552469734F, 
  0.3590499106F, 0.3628615659F, 0.3666816630F, 0.3705099239F, 
  0.3743460698F, 0.3781898204F, 0.3820408945F, 0.3858990095F, 
  0.3897638820F, 0.3936352274F, 0.3975127601F, 0.4013961936F, 
  0.4052852405F, 0.4091796123F, 0.4130790198F, 0.4169831732F, 
  0.4208917815F, 0.4248045534F, 0.4287211965F, 0.4326414181F, 
  0.4365649248F, 0.4404914225F, 0.4444206167F, 0.4483522125F, 
  0.4522859146F, 0.4562214270F, 0.4601584538F, 0.4640966984F, 
  0.4680358644F, 0.4719756548F, 0.4759157726F, 0.4798559209F, 
  0.4837958024F, 0.4877351199F, 0.4916735765F, 0.4956108751F, 
  0.4995467188F, 0.5034808109F, 0.5074128550F, 0.5113425550F, 
  0.5152696149F, 0.5191937395F, 0.5231146336F, 0.5270320028F, 
  0.5309455530F, 0.5348549910F, 0.5387600239F, 0.5426603597F, 
  0.5465557070F, 0.5504457754F, 0.5543302752F, 0.5582089175F, 
  0.5620814145F, 0.5659474793F, 0.5698068262F, 0.5736591704F, 
  0.5775042283F, 0.5813417176F, 0.5851713571F, 0.5889928670F, 
  0.5928059689F, 0.5966103856F, 0.6004058415F, 0.6041920626F, 
  0.6079687761F, 0.6117357113F, 0.6154925986F, 0.6192391705F, 
  0.6229751612F, 0.6267003064F, 0.6304143441F, 0.6341170137F, 
  0.6378080569F, 0.6414872173F, 0.6451542405F, 0.6488088741F, 
  0.6524508681F, 0.6560799742F, 0.6596959469F, 0.6632985424F, 
  0.6668875197F, 0.6704626398F, 0.6740236662F, 0.6775703649F, 
  0.6811025043F, 0.6846198554F, 0.6881221916F, 0.6916092892F, 
  0.6950809269F, 0.6985368861F, 0.7019769510F, 0.7054009085F, 
  0.7088085484F, 0.7121996632F, 0.7155740484F, 0.7189315023F, 
  0.7222718263F, 0.7255948245F, 0.7289003043F, 0.7321880760F, 
  0.7354579530F, 0.7387097518F, 0.7419432921F, 0.7451583966F, 
  0.7483548915F, 0.7515326059F, 0.7546913723F, 0.7578310265F, 
  0.7609514077F, 0.7640523581F, 0.7671337237F, 0.7701953535F, 
  0.7732371001F, 0.7762588195F, 0.7792603711F, 0.7822416178F, 
  0.7852024259F, 0.7881426654F, 0.7910622097F, 0.7939609356F, 
  0.7968387237F, 0.7996954579F, 0.8025310261F, 0.8053453193F, 
  0.8081382324F, 0.8109096638F, 0.8136595156F, 0.8163876936F, 
  0.8190941071F, 0.8217786690F, 0.8244412960F, 0.8270819086F, 
  0.8297004305F, 0.8322967896F, 0.8348709171F, 0.8374227481F, 
  0.8399522213F, 0.8424592789F, 0.8449438672F, 0.8474059356F, 
  0.8498454378F, 0.8522623306F, 0.8546565748F, 0.8570281348F, 
  0.8593769787F, 0.8617030779F, 0.8640064080F, 0.8662869477F, 
  0.8685446796F, 0.8707795899F, 0.8729916682F, 0.8751809079F, 
  0.8773473059F, 0.8794908626F, 0.8816115819F, 0.8837094713F, 
  0.8857845418F, 0.8878368079F, 0.8898662874F, 0.8918730019F, 
  0.8938569760F, 0.8958182380F, 0.8977568194F, 0.8996727552F, 
  0.9015660837F, 0.9034368465F, 0.9052850885F, 0.9071108577F, 
  0.9089142057F, 0.9106951869F, 0.9124538591F, 0.9141902832F, 
  0.9159045233F, 0.9175966464F, 0.9192667228F, 0.9209148257F, 
  0.9225410313F, 0.9241454187F, 0.9257280701F, 0.9272890704F, 
  0.9288285075F, 0.9303464720F, 0.9318430576F, 0.9333183603F, 
  0.9347724792F, 0.9362055158F, 0.9376175745F, 0.9390087622F, 
  0.9403791881F, 0.9417289644F, 0.9430582055F, 0.9443670283F, 
  0.9456555521F, 0.9469238986F, 0.9481721917F, 0.9494005577F, 
  0.9506091252F, 0.9517980248F, 0.9529673894F, 0.9541173540F, 
  0.9552480557F, 0.9563596334F, 0.9574522282F, 0.9585259830F, 
  0.9595810428F, 0.9606175542F, 0.9616356656F, 0.9626355274F, 
  0.9636172915F, 0.9645811114F, 0.9655271425F, 0.9664555414F, 
  0.9673664664F, 0.9682600774F, 0.9691365355F, 0.9699960034F, 
  0.9708386448F, 0.9716646250F, 0.9724741103F, 0.9732672685F, 
  0.9740442683F, 0.9748052795F, 0.9755504729F, 0.9762800205F, 
  0.9769940950F, 0.9776928703F, 0.9783765210F, 0.9790452223F, 
  0.9796991504F, 0.9803384823F, 0.9809633954F, 0.9815740679F, 
  0.9821706784F, 0.9827534063F, 0.9833224312F, 0.9838779332F, 
  0.9844200928F, 0.9849490910F, 0.9854651087F, 0.9859683274F, 
  0.9864589286F, 0.9869370940F, 0.9874030054F, 0.9878568447F, 
  0.9882987937F, 0.9887290343F, 0.9891477481F, 0.9895551169F, 
  0.9899513220F, 0.9903365446F, 0.9907109658F, 0.9910747662F, 
  0.9914281260F, 0.9917712252F, 0.9921042433F, 0.9924273593F, 
  0.9927407516F, 0.9930445982F, 0.9933390763F, 0.9936243626F, 
  0.9939006331F, 0.9941680631F, 0.9944268269F, 0.9946770982F, 
  0.9949190498F, 0.9951528537F, 0.9953786808F, 0.9955967011F, 
  0.9958070836F, 0.9960099963F, 0.9962056061F, 0.9963940787F, 
  0.9965755786F, 0.9967502693F, 0.9969183129F, 0.9970798704F, 
  0.9972351013F, 0.9973841640F, 0.9975272151F, 0.9976644103F, 
  0.9977959036F, 0.9979218476F, 0.9980423932F, 0.9981576901F, 
  0.9982678862F, 0.9983731278F, 0.9984735596F, 0.9985693247F, 
  0.9986605645F, 0.9987474186F, 0.9988300248F, 0.9989085193F, 
  0.9989830364F, 0.9990537085F, 0.9991206662F, 0.9991840382F, 
  0.9992439513F, 0.9993005303F, 0.9993538982F, 0.9994041757F, 
  0.9994514817F, 0.9994959330F, 0.9995376444F, 0.9995767286F, 
  0.9996132960F, 0.9996474550F, 0.9996793121F, 0.9997089710F, 
  0.9997365339F, 0.9997621003F, 0.9997857677F, 0.9998076311F, 
  0.9998277836F, 0.9998463156F, 0.9998633155F, 0.9998788692F, 
  0.9998930603F, 0.9999059701F, 0.9999176774F, 0.9999282586F, 
  0.9999377880F, 0.9999463370F, 0.9999539749F, 0.9999607685F, 
  0.9999667820F, 0.9999720773F, 0.9999767136F, 0.9999807479F, 
  0.9999842344F, 0.9999872249F, 0.9999897688F, 0.9999919127F, 
  0.9999937009F, 0.9999951749F, 0.9999963738F, 0.9999973342F, 
  0.9999980900F, 0.9999986724F, 0.9999991103F, 0.9999994297F, 
  0.9999996543F, 0.9999998049F, 0.9999999000F, 0.9999999552F, 
  0.9999999836F, 0.9999999957F, 0.9999999994F, 1.0000000000F, 
};

static float vwin2048[1024] = {
  0.0000009241F, 0.0000083165F, 0.0000231014F, 0.0000452785F, 
  0.0000748476F, 0.0001118085F, 0.0001561608F, 0.0002079041F, 
  0.0002670379F, 0.0003335617F, 0.0004074748F, 0.0004887765F, 
  0.0005774661F, 0.0006735427F, 0.0007770054F, 0.0008878533F, 
  0.0010060853F, 0.0011317002F, 0.0012646969F, 0.0014050742F, 
  0.0015528307F, 0.0017079650F, 0.0018704756F, 0.0020403610F, 
  0.0022176196F, 0.0024022497F, 0.0025942495F, 0.0027936173F, 
  0.0030003511F, 0.0032144490F, 0.0034359088F, 0.0036647286F, 
  0.0039009061F, 0.0041444391F, 0.0043953253F, 0.0046535621F, 
  0.0049191472F, 0.0051920781F, 0.0054723520F, 0.0057599664F, 
  0.0060549184F, 0.0063572052F, 0.0066668239F, 0.0069837715F, 
  0.0073080449F, 0.0076396410F, 0.0079785566F, 0.0083247884F, 
  0.0086783330F, 0.0090391871F, 0.0094073470F, 0.0097828092F, 
  0.0101655700F, 0.0105556258F, 0.0109529726F, 0.0113576065F, 
  0.0117695237F, 0.0121887200F, 0.0126151913F, 0.0130489335F, 
  0.0134899422F, 0.0139382130F, 0.0143937415F, 0.0148565233F, 
  0.0153265536F, 0.0158038279F, 0.0162883413F, 0.0167800889F, 
  0.0172790660F, 0.0177852675F, 0.0182986882F, 0.0188193231F, 
  0.0193471668F, 0.0198822141F, 0.0204244594F, 0.0209738974F, 
  0.0215305225F, 0.0220943289F, 0.0226653109F, 0.0232434627F, 
  0.0238287784F, 0.0244212519F, 0.0250208772F, 0.0256276481F, 
  0.0262415582F, 0.0268626014F, 0.0274907711F, 0.0281260608F, 
  0.0287684638F, 0.0294179736F, 0.0300745833F, 0.0307382859F, 
  0.0314090747F, 0.0320869424F, 0.0327718819F, 0.0334638860F, 
  0.0341629474F, 0.0348690586F, 0.0355822122F, 0.0363024004F, 
  0.0370296157F, 0.0377638502F, 0.0385050960F, 0.0392533451F, 
  0.0400085896F, 0.0407708211F, 0.0415400315F, 0.0423162123F, 
  0.0430993552F, 0.0438894515F, 0.0446864926F, 0.0454904698F, 
  0.0463013742F, 0.0471191969F, 0.0479439288F, 0.0487755607F, 
  0.0496140836F, 0.0504594879F, 0.0513117642F, 0.0521709031F, 
  0.0530368949F, 0.0539097297F, 0.0547893979F, 0.0556758894F, 
  0.0565691941F, 0.0574693019F, 0.0583762026F, 0.0592898858F, 
  0.0602103410F, 0.0611375576F, 0.0620715250F, 0.0630122324F, 
  0.0639596688F, 0.0649138234F, 0.0658746848F, 0.0668422421F, 
  0.0678164838F, 0.0687973985F, 0.0697849746F, 0.0707792005F, 
  0.0717800645F, 0.0727875547F, 0.0738016591F, 0.0748223656F, 
  0.0758496620F, 0.0768835359F, 0.0779239751F, 0.0789709668F, 
  0.0800244985F, 0.0810845574F, 0.0821511306F, 0.0832242052F, 
  0.0843037679F, 0.0853898056F, 0.0864823050F, 0.0875812525F, 
  0.0886866347F, 0.0897984378F, 0.0909166480F, 0.0920412513F, 
  0.0931722338F, 0.0943095813F, 0.0954532795F, 0.0966033140F, 
  0.0977596702F, 0.0989223336F, 0.1000912894F, 0.1012665227F, 
  0.1024480185F, 0.1036357616F, 0.1048297369F, 0.1060299290F, 
  0.1072363224F, 0.1084489014F, 0.1096676504F, 0.1108925534F, 
  0.1121235946F, 0.1133607577F, 0.1146040267F, 0.1158533850F, 
  0.1171088163F, 0.1183703040F, 0.1196378312F, 0.1209113812F, 
  0.1221909370F, 0.1234764815F, 0.1247679974F, 0.1260654674F, 
  0.1273688740F, 0.1286781995F, 0.1299934263F, 0.1313145365F, 
  0.1326415121F, 0.1339743349F, 0.1353129866F, 0.1366574490F, 
  0.1380077035F, 0.1393637315F, 0.1407255141F, 0.1420930325F, 
  0.1434662677F, 0.1448452004F, 0.1462298115F, 0.1476200814F, 
  0.1490159906F, 0.1504175195F, 0.1518246482F, 0.1532373569F, 
  0.1546556253F, 0.1560794333F, 0.1575087606F, 0.1589435866F, 
  0.1603838909F, 0.1618296526F, 0.1632808509F, 0.1647374648F, 
  0.1661994731F, 0.1676668546F, 0.1691395880F, 0.1706176516F, 
  0.1721010238F, 0.1735896829F, 0.1750836068F, 0.1765827736F, 
  0.1780871610F, 0.1795967468F, 0.1811115084F, 0.1826314234F, 
  0.1841564689F, 0.1856866221F, 0.1872218600F, 0.1887621595F, 
  0.1903074974F, 0.1918578503F, 0.1934131947F, 0.1949735068F, 
  0.1965387630F, 0.1981089393F, 0.1996840117F, 0.2012639560F, 
  0.2028487479F, 0.2044383630F, 0.2060327766F, 0.2076319642F, 
  0.2092359007F, 0.2108445614F, 0.2124579211F, 0.2140759545F, 
  0.2156986364F, 0.2173259411F, 0.2189578432F, 0.2205943168F, 
  0.2222353361F, 0.2238808751F, 0.2255309076F, 0.2271854073F, 
  0.2288443480F, 0.2305077030F, 0.2321754457F, 0.2338475493F, 
  0.2355239869F, 0.2372047315F, 0.2388897560F, 0.2405790329F, 
  0.2422725350F, 0.2439702347F, 0.2456721043F, 0.2473781159F, 
  0.2490882418F, 0.2508024539F, 0.2525207240F, 0.2542430237F, 
  0.2559693248F, 0.2576995986F, 0.2594338166F, 0.2611719498F, 
  0.2629139695F, 0.2646598466F, 0.2664095520F, 0.2681630564F, 
  0.2699203304F, 0.2716813445F, 0.2734460691F, 0.2752144744F, 
  0.2769865307F, 0.2787622079F, 0.2805414760F, 0.2823243047F, 
  0.2841106637F, 0.2859005227F, 0.2876938509F, 0.2894906179F, 
  0.2912907928F, 0.2930943447F, 0.2949012426F, 0.2967114554F, 
  0.2985249520F, 0.3003417009F, 0.3021616708F, 0.3039848301F, 
  0.3058111471F, 0.3076405901F, 0.3094731273F, 0.3113087266F, 
  0.3131473560F, 0.3149889833F, 0.3168335762F, 0.3186811024F, 
  0.3205315294F, 0.3223848245F, 0.3242409552F, 0.3260998886F, 
  0.3279615918F, 0.3298260319F, 0.3316931758F, 0.3335629903F, 
  0.3354354423F, 0.3373104982F, 0.3391881247F, 0.3410682882F, 
  0.3429509551F, 0.3448360917F, 0.3467236642F, 0.3486136387F, 
  0.3505059811F, 0.3524006575F, 0.3542976336F, 0.3561968753F, 
  0.3580983482F, 0.3600020179F, 0.3619078499F, 0.3638158096F, 
  0.3657258625F, 0.3676379737F, 0.3695521086F, 0.3714682321F, 
  0.3733863094F, 0.3753063055F, 0.3772281852F, 0.3791519134F, 
  0.3810774548F, 0.3830047742F, 0.3849338362F, 0.3868646053F, 
  0.3887970459F, 0.3907311227F, 0.3926667998F, 0.3946040417F, 
  0.3965428125F, 0.3984830765F, 0.4004247978F, 0.4023679403F, 
  0.4043124683F, 0.4062583455F, 0.4082055359F, 0.4101540034F, 
  0.4121037117F, 0.4140546246F, 0.4160067058F, 0.4179599190F, 
  0.4199142277F, 0.4218695956F, 0.4238259861F, 0.4257833627F, 
  0.4277416888F, 0.4297009279F, 0.4316610433F, 0.4336219983F, 
  0.4355837562F, 0.4375462803F, 0.4395095337F, 0.4414734797F, 
  0.4434380815F, 0.4454033021F, 0.4473691046F, 0.4493354521F, 
  0.4513023078F, 0.4532696345F, 0.4552373954F, 0.4572055533F, 
  0.4591740713F, 0.4611429123F, 0.4631120393F, 0.4650814151F, 
  0.4670510028F, 0.4690207650F, 0.4709906649F, 0.4729606651F, 
  0.4749307287F, 0.4769008185F, 0.4788708972F, 0.4808409279F, 
  0.4828108732F, 0.4847806962F, 0.4867503597F, 0.4887198264F, 
  0.4906890593F, 0.4926580213F, 0.4946266753F, 0.4965949840F, 
  0.4985629105F, 0.5005304176F, 0.5024974683F, 0.5044640255F, 
  0.5064300522F, 0.5083955114F, 0.5103603659F, 0.5123245790F, 
  0.5142881136F, 0.5162509328F, 0.5182129997F, 0.5201742774F, 
  0.5221347290F, 0.5240943178F, 0.5260530070F, 0.5280107598F, 
  0.5299675395F, 0.5319233095F, 0.5338780330F, 0.5358316736F, 
  0.5377841946F, 0.5397355596F, 0.5416857320F, 0.5436346755F, 
  0.5455823538F, 0.5475287304F, 0.5494737691F, 0.5514174337F, 
  0.5533596881F, 0.5553004962F, 0.5572398218F, 0.5591776291F, 
  0.5611138821F, 0.5630485449F, 0.5649815818F, 0.5669129570F, 
  0.5688426349F, 0.5707705799F, 0.5726967564F, 0.5746211290F, 
  0.5765436624F, 0.5784643212F, 0.5803830702F, 0.5822998743F, 
  0.5842146984F, 0.5861275076F, 0.5880382669F, 0.5899469416F, 
  0.5918534968F, 0.5937578981F, 0.5956601107F, 0.5975601004F, 
  0.5994578326F, 0.6013532732F, 0.6032463880F, 0.6051371429F, 
  0.6070255039F, 0.6089114372F, 0.6107949090F, 0.6126758856F, 
  0.6145543334F, 0.6164302191F, 0.6183035092F, 0.6201741706F, 
  0.6220421700F, 0.6239074745F, 0.6257700513F, 0.6276298674F, 
  0.6294868903F, 0.6313410873F, 0.6331924262F, 0.6350408745F, 
  0.6368864001F, 0.6387289710F, 0.6405685552F, 0.6424051209F, 
  0.6442386364F, 0.6460690702F, 0.6478963910F, 0.6497205673F, 
  0.6515415682F, 0.6533593625F, 0.6551739194F, 0.6569852082F, 
  0.6587931984F, 0.6605978593F, 0.6623991609F, 0.6641970728F, 
  0.6659915652F, 0.6677826081F, 0.6695701718F, 0.6713542268F, 
  0.6731347437F, 0.6749116932F, 0.6766850461F, 0.6784547736F, 
  0.6802208469F, 0.6819832374F, 0.6837419164F, 0.6854968559F, 
  0.6872480275F, 0.6889954034F, 0.6907389556F, 0.6924786566F, 
  0.6942144788F, 0.6959463950F, 0.6976743780F, 0.6993984008F, 
  0.7011184365F, 0.7028344587F, 0.7045464407F, 0.7062543564F, 
  0.7079581796F, 0.7096578844F, 0.7113534450F, 0.7130448359F, 
  0.7147320316F, 0.7164150070F, 0.7180937371F, 0.7197681970F, 
  0.7214383620F, 0.7231042077F, 0.7247657098F, 0.7264228443F, 
  0.7280755871F, 0.7297239147F, 0.7313678035F, 0.7330072301F, 
  0.7346421715F, 0.7362726046F, 0.7378985069F, 0.7395198556F, 
  0.7411366285F, 0.7427488034F, 0.7443563584F, 0.7459592717F, 
  0.7475575218F, 0.7491510873F, 0.7507399471F, 0.7523240803F, 
  0.7539034661F, 0.7554780839F, 0.7570479136F, 0.7586129349F, 
  0.7601731279F, 0.7617284730F, 0.7632789506F, 0.7648245416F, 
  0.7663652267F, 0.7679009872F, 0.7694318044F, 0.7709576599F, 
  0.7724785354F, 0.7739944130F, 0.7755052749F, 0.7770111035F, 
  0.7785118815F, 0.7800075916F, 0.7814982170F, 0.7829837410F, 
  0.7844641472F, 0.7859394191F, 0.7874095408F, 0.7888744965F, 
  0.7903342706F, 0.7917888476F, 0.7932382124F, 0.7946823501F, 
  0.7961212460F, 0.7975548855F, 0.7989832544F, 0.8004063386F, 
  0.8018241244F, 0.8032365981F, 0.8046437463F, 0.8060455560F, 
  0.8074420141F, 0.8088331080F, 0.8102188253F, 0.8115991536F, 
  0.8129740810F, 0.8143435957F, 0.8157076861F, 0.8170663409F, 
  0.8184195489F, 0.8197672994F, 0.8211095817F, 0.8224463853F, 
  0.8237777001F, 0.8251035161F, 0.8264238235F, 0.8277386129F, 
  0.8290478750F, 0.8303516008F, 0.8316497814F, 0.8329424083F, 
  0.8342294731F, 0.8355109677F, 0.8367868841F, 0.8380572148F, 
  0.8393219523F, 0.8405810893F, 0.8418346190F, 0.8430825345F, 
  0.8443248294F, 0.8455614974F, 0.8467925323F, 0.8480179285F, 
  0.8492376802F, 0.8504517822F, 0.8516602292F, 0.8528630164F, 
  0.8540601391F, 0.8552515928F, 0.8564373733F, 0.8576174766F, 
  0.8587918990F, 0.8599606368F, 0.8611236868F, 0.8622810460F, 
  0.8634327113F, 0.8645786802F, 0.8657189504F, 0.8668535195F, 
  0.8679823857F, 0.8691055472F, 0.8702230025F, 0.8713347503F, 
  0.8724407896F, 0.8735411194F, 0.8746357394F, 0.8757246489F, 
  0.8768078479F, 0.8778853364F, 0.8789571146F, 0.8800231832F, 
  0.8810835427F, 0.8821381942F, 0.8831871387F, 0.8842303777F, 
  0.8852679127F, 0.8862997456F, 0.8873258784F, 0.8883463132F, 
  0.8893610527F, 0.8903700994F, 0.8913734562F, 0.8923711263F, 
  0.8933631129F, 0.8943494196F, 0.8953300500F, 0.8963050083F, 
  0.8972742985F, 0.8982379249F, 0.8991958922F, 0.9001482052F, 
  0.9010948688F, 0.9020358883F, 0.9029712690F, 0.9039010165F, 
  0.9048251367F, 0.9057436357F, 0.9066565195F, 0.9075637946F, 
  0.9084654678F, 0.9093615456F, 0.9102520353F, 0.9111369440F, 
  0.9120162792F, 0.9128900484F, 0.9137582595F, 0.9146209204F, 
  0.9154780394F, 0.9163296248F, 0.9171756853F, 0.9180162296F, 
  0.9188512667F, 0.9196808057F, 0.9205048559F, 0.9213234270F, 
  0.9221365285F, 0.9229441704F, 0.9237463629F, 0.9245431160F, 
  0.9253344404F, 0.9261203465F, 0.9269008453F, 0.9276759477F, 
  0.9284456648F, 0.9292100080F, 0.9299689889F, 0.9307226190F, 
  0.9314709103F, 0.9322138747F, 0.9329515245F, 0.9336838721F, 
  0.9344109300F, 0.9351327108F, 0.9358492275F, 0.9365604931F, 
  0.9372665208F, 0.9379673239F, 0.9386629160F, 0.9393533107F, 
  0.9400385220F, 0.9407185637F, 0.9413934501F, 0.9420631954F, 
  0.9427278141F, 0.9433873208F, 0.9440417304F, 0.9446910576F, 
  0.9453353176F, 0.9459745255F, 0.9466086968F, 0.9472378469F, 
  0.9478619915F, 0.9484811463F, 0.9490953274F, 0.9497045506F, 
  0.9503088323F, 0.9509081888F, 0.9515026365F, 0.9520921921F, 
  0.9526768723F, 0.9532566940F, 0.9538316742F, 0.9544018300F, 
  0.9549671786F, 0.9555277375F, 0.9560835241F, 0.9566345562F, 
  0.9571808513F, 0.9577224275F, 0.9582593027F, 0.9587914949F, 
  0.9593190225F, 0.9598419038F, 0.9603601571F, 0.9608738012F, 
  0.9613828546F, 0.9618873361F, 0.9623872646F, 0.9628826591F, 
  0.9633735388F, 0.9638599227F, 0.9643418303F, 0.9648192808F, 
  0.9652922939F, 0.9657608890F, 0.9662250860F, 0.9666849046F, 
  0.9671403646F, 0.9675914861F, 0.9680382891F, 0.9684807937F, 
  0.9689190202F, 0.9693529890F, 0.9697827203F, 0.9702082347F, 
  0.9706295529F, 0.9710466953F, 0.9714596828F, 0.9718685362F, 
  0.9722732762F, 0.9726739240F, 0.9730705005F, 0.9734630267F, 
  0.9738515239F, 0.9742360134F, 0.9746165163F, 0.9749930540F, 
  0.9753656481F, 0.9757343198F, 0.9760990909F, 0.9764599829F, 
  0.9768170175F, 0.9771702164F, 0.9775196013F, 0.9778651941F, 
  0.9782070167F, 0.9785450909F, 0.9788794388F, 0.9792100824F, 
  0.9795370437F, 0.9798603449F, 0.9801800080F, 0.9804960554F, 
  0.9808085092F, 0.9811173916F, 0.9814227251F, 0.9817245318F, 
  0.9820228343F, 0.9823176549F, 0.9826090160F, 0.9828969402F, 
  0.9831814498F, 0.9834625674F, 0.9837403156F, 0.9840147169F, 
  0.9842857939F, 0.9845535692F, 0.9848180654F, 0.9850793052F, 
  0.9853373113F, 0.9855921062F, 0.9858437127F, 0.9860921535F, 
  0.9863374512F, 0.9865796287F, 0.9868187085F, 0.9870547136F, 
  0.9872876664F, 0.9875175899F, 0.9877445067F, 0.9879684396F, 
  0.9881894112F, 0.9884074444F, 0.9886225619F, 0.9888347863F, 
  0.9890441404F, 0.9892506468F, 0.9894543284F, 0.9896552077F, 
  0.9898533074F, 0.9900486502F, 0.9902412587F, 0.9904311555F, 
  0.9906183633F, 0.9908029045F, 0.9909848019F, 0.9911640779F, 
  0.9913407550F, 0.9915148557F, 0.9916864025F, 0.9918554179F, 
  0.9920219241F, 0.9921859437F, 0.9923474989F, 0.9925066120F, 
  0.9926633054F, 0.9928176012F, 0.9929695218F, 0.9931190891F, 
  0.9932663254F, 0.9934112527F, 0.9935538932F, 0.9936942686F, 
  0.9938324012F, 0.9939683126F, 0.9941020248F, 0.9942335597F, 
  0.9943629388F, 0.9944901841F, 0.9946153170F, 0.9947383593F, 
  0.9948593325F, 0.9949782579F, 0.9950951572F, 0.9952100516F, 
  0.9953229625F, 0.9954339111F, 0.9955429186F, 0.9956500062F, 
  0.9957551948F, 0.9958585056F, 0.9959599593F, 0.9960595769F, 
  0.9961573792F, 0.9962533869F, 0.9963476206F, 0.9964401009F, 
  0.9965308483F, 0.9966198833F, 0.9967072261F, 0.9967928971F, 
  0.9968769164F, 0.9969593041F, 0.9970400804F, 0.9971192651F, 
  0.9971968781F, 0.9972729391F, 0.9973474680F, 0.9974204842F, 
  0.9974920074F, 0.9975620569F, 0.9976306521F, 0.9976978122F, 
  0.9977635565F, 0.9978279039F, 0.9978908736F, 0.9979524842F, 
  0.9980127547F, 0.9980717037F, 0.9981293499F, 0.9981857116F, 
  0.9982408073F, 0.9982946554F, 0.9983472739F, 0.9983986810F, 
  0.9984488947F, 0.9984979328F, 0.9985458132F, 0.9985925534F, 
  0.9986381711F, 0.9986826838F, 0.9987261086F, 0.9987684630F, 
  0.9988097640F, 0.9988500286F, 0.9988892738F, 0.9989275163F, 
  0.9989647727F, 0.9990010597F, 0.9990363938F, 0.9990707911F, 
  0.9991042679F, 0.9991368404F, 0.9991685244F, 0.9991993358F, 
  0.9992292905F, 0.9992584038F, 0.9992866914F, 0.9993141686F, 
  0.9993408506F, 0.9993667526F, 0.9993918895F, 0.9994162761F, 
  0.9994399273F, 0.9994628576F, 0.9994850815F, 0.9995066133F, 
  0.9995274672F, 0.9995476574F, 0.9995671978F, 0.9995861021F, 
  0.9996043841F, 0.9996220573F, 0.9996391352F, 0.9996556310F, 
  0.9996715579F, 0.9996869288F, 0.9997017568F, 0.9997160543F, 
  0.9997298342F, 0.9997431088F, 0.9997558905F, 0.9997681914F, 
  0.9997800236F, 0.9997913990F, 0.9998023292F, 0.9998128261F, 
  0.9998229009F, 0.9998325650F, 0.9998418296F, 0.9998507058F, 
  0.9998592044F, 0.9998673362F, 0.9998751117F, 0.9998825415F, 
  0.9998896358F, 0.9998964047F, 0.9999028584F, 0.9999090066F, 
  0.9999148590F, 0.9999204253F, 0.9999257148F, 0.9999307368F, 
  0.9999355003F, 0.9999400144F, 0.9999442878F, 0.9999483293F, 
  0.9999521472F, 0.9999557499F, 0.9999591457F, 0.9999623426F, 
  0.9999653483F, 0.9999681708F, 0.9999708175F, 0.9999732959F, 
  0.9999756132F, 0.9999777765F, 0.9999797928F, 0.9999816688F, 
  0.9999834113F, 0.9999850266F, 0.9999865211F, 0.9999879009F, 
  0.9999891721F, 0.9999903405F, 0.9999914118F, 0.9999923914F, 
  0.9999932849F, 0.9999940972F, 0.9999948336F, 0.9999954989F, 
  0.9999960978F, 0.9999966349F, 0.9999971146F, 0.9999975411F, 
  0.9999979185F, 0.9999982507F, 0.9999985414F, 0.9999987944F, 
  0.9999990129F, 0.9999992003F, 0.9999993596F, 0.9999994939F, 
  0.9999996059F, 0.9999996981F, 0.9999997732F, 0.9999998333F, 
  0.9999998805F, 0.9999999170F, 0.9999999444F, 0.9999999643F, 
  0.9999999784F, 0.9999999878F, 0.9999999937F, 0.9999999972F, 
  0.9999999990F, 0.9999999997F, 1.0000000000F, 1.0000000000F, 
};

static float vwin4096[2048] = {
  0.0000002310F, 0.0000020791F, 0.0000057754F, 0.0000113197F, 
  0.0000187121F, 0.0000279526F, 0.0000390412F, 0.0000519777F, 
  0.0000667623F, 0.0000833949F, 0.0001018753F, 0.0001222036F, 
  0.0001443798F, 0.0001684037F, 0.0001942754F, 0.0002219947F, 
  0.0002515616F, 0.0002829761F, 0.0003162380F, 0.0003513472F, 
  0.0003883038F, 0.0004271076F, 0.0004677584F, 0.0005102563F, 
  0.0005546011F, 0.0006007928F, 0.0006488311F, 0.0006987160F, 
  0.0007504474F, 0.0008040251F, 0.0008594490F, 0.0009167191F, 
  0.0009758351F, 0.0010367969F, 0.0010996044F, 0.0011642574F, 
  0.0012307558F, 0.0012990994F, 0.0013692880F, 0.0014413216F, 
  0.0015151998F, 0.0015909226F, 0.0016684898F, 0.0017479011F, 
  0.0018291565F, 0.0019122556F, 0.0019971983F, 0.0020839845F, 
  0.0021726138F, 0.0022630861F, 0.0023554012F, 0.0024495588F, 
  0.0025455588F, 0.0026434008F, 0.0027430847F, 0.0028446103F, 
  0.0029479772F, 0.0030531853F, 0.0031602342F, 0.0032691238F, 
  0.0033798538F, 0.0034924239F, 0.0036068338F, 0.0037230833F, 
  0.0038411721F, 0.0039610999F, 0.0040828664F, 0.0042064714F, 
  0.0043319145F, 0.0044591954F, 0.0045883139F, 0.0047192696F, 
  0.0048520622F, 0.0049866914F, 0.0051231569F, 0.0052614583F, 
  0.0054015953F, 0.0055435676F, 0.0056873748F, 0.0058330166F, 
  0.0059804926F, 0.0061298026F, 0.0062809460F, 0.0064339226F, 
  0.0065887320F, 0.0067453738F, 0.0069038476F, 0.0070641531F, 
  0.0072262899F, 0.0073902575F, 0.0075560556F, 0.0077236838F, 
  0.0078931417F, 0.0080644288F, 0.0082375447F, 0.0084124891F, 
  0.0085892615F, 0.0087678614F, 0.0089482885F, 0.0091305422F, 
  0.0093146223F, 0.0095005281F, 0.0096882592F, 0.0098778153F, 
  0.0100691958F, 0.0102624002F, 0.0104574281F, 0.0106542791F, 
  0.0108529525F, 0.0110534480F, 0.0112557651F, 0.0114599032F, 
  0.0116658618F, 0.0118736405F, 0.0120832387F, 0.0122946560F, 
  0.0125078917F, 0.0127229454F, 0.0129398166F, 0.0131585046F, 
  0.0133790090F, 0.0136013292F, 0.0138254647F, 0.0140514149F, 
  0.0142791792F, 0.0145087572F, 0.0147401481F, 0.0149733515F, 
  0.0152083667F, 0.0154451932F, 0.0156838304F, 0.0159242777F, 
  0.0161665345F, 0.0164106001F, 0.0166564741F, 0.0169041557F, 
  0.0171536443F, 0.0174049393F, 0.0176580401F, 0.0179129461F, 
  0.0181696565F, 0.0184281708F, 0.0186884883F, 0.0189506084F, 
  0.0192145303F, 0.0194802535F, 0.0197477772F, 0.0200171008F, 
  0.0202882236F, 0.0205611449F, 0.0208358639F, 0.0211123801F, 
  0.0213906927F, 0.0216708011F, 0.0219527043F, 0.0222364019F, 
  0.0225218930F, 0.0228091769F, 0.0230982529F, 0.0233891203F, 
  0.0236817782F, 0.0239762259F, 0.0242724628F, 0.0245704880F, 
  0.0248703007F, 0.0251719002F, 0.0254752858F, 0.0257804565F, 
  0.0260874117F, 0.0263961506F, 0.0267066722F, 0.0270189760F, 
  0.0273330609F, 0.0276489263F, 0.0279665712F, 0.0282859949F, 
  0.0286071966F, 0.0289301753F, 0.0292549303F, 0.0295814607F, 
  0.0299097656F, 0.0302398442F, 0.0305716957F, 0.0309053191F, 
  0.0312407135F, 0.0315778782F, 0.0319168122F, 0.0322575145F, 
  0.0325999844F, 0.0329442209F, 0.0332902231F, 0.0336379900F, 
  0.0339875208F, 0.0343388146F, 0.0346918703F, 0.0350466871F, 
  0.0354032640F, 0.0357616000F, 0.0361216943F, 0.0364835458F, 
  0.0368471535F, 0.0372125166F, 0.0375796339F, 0.0379485046F, 
  0.0383191276F, 0.0386915020F, 0.0390656267F, 0.0394415008F, 
  0.0398191231F, 0.0401984927F, 0.0405796086F, 0.0409624698F, 
  0.0413470751F, 0.0417334235F, 0.0421215141F, 0.0425113457F, 
  0.0429029172F, 0.0432962277F, 0.0436912760F, 0.0440880610F, 
  0.0444865817F, 0.0448868370F, 0.0452888257F, 0.0456925468F, 
  0.0460979992F, 0.0465051816F, 0.0469140931F, 0.0473247325F, 
  0.0477370986F, 0.0481511902F, 0.0485670064F, 0.0489845458F, 
  0.0494038074F, 0.0498247899F, 0.0502474922F, 0.0506719131F, 
  0.0510980514F, 0.0515259060F, 0.0519554756F, 0.0523867590F, 
  0.0528197550F, 0.0532544624F, 0.0536908800F, 0.0541290066F, 
  0.0545688408F, 0.0550103815F, 0.0554536274F, 0.0558985772F, 
  0.0563452297F, 0.0567935837F, 0.0572436377F, 0.0576953907F, 
  0.0581488412F, 0.0586039880F, 0.0590608297F, 0.0595193651F, 
  0.0599795929F, 0.0604415117F, 0.0609051202F, 0.0613704170F, 
  0.0618374009F, 0.0623060704F, 0.0627764243F, 0.0632484611F, 
  0.0637221795F, 0.0641975781F, 0.0646746555F, 0.0651534104F, 
  0.0656338413F, 0.0661159469F, 0.0665997257F, 0.0670851763F, 
  0.0675722973F, 0.0680610873F, 0.0685515448F, 0.0690436684F, 
  0.0695374567F, 0.0700329081F, 0.0705300213F, 0.0710287947F, 
  0.0715292269F, 0.0720313163F, 0.0725350616F, 0.0730404612F, 
  0.0735475136F, 0.0740562172F, 0.0745665707F, 0.0750785723F, 
  0.0755922207F, 0.0761075143F, 0.0766244515F, 0.0771430307F, 
  0.0776632505F, 0.0781851092F, 0.0787086052F, 0.0792337371F, 
  0.0797605032F, 0.0802889018F, 0.0808189315F, 0.0813505905F, 
  0.0818838773F, 0.0824187903F, 0.0829553277F, 0.0834934881F, 
  0.0840332697F, 0.0845746708F, 0.0851176899F, 0.0856623252F, 
  0.0862085751F, 0.0867564379F, 0.0873059119F, 0.0878569954F, 
  0.0884096867F, 0.0889639840F, 0.0895198858F, 0.0900773902F, 
  0.0906364955F, 0.0911972000F, 0.0917595019F, 0.0923233995F, 
  0.0928888909F, 0.0934559745F, 0.0940246485F, 0.0945949110F, 
  0.0951667604F, 0.0957401946F, 0.0963152121F, 0.0968918109F, 
  0.0974699893F, 0.0980497454F, 0.0986310773F, 0.0992139832F, 
  0.0997984614F, 0.1003845098F, 0.1009721267F, 0.1015613101F, 
  0.1021520582F, 0.1027443692F, 0.1033382410F, 0.1039336718F, 
  0.1045306597F, 0.1051292027F, 0.1057292990F, 0.1063309466F, 
  0.1069341435F, 0.1075388878F, 0.1081451776F, 0.1087530108F, 
  0.1093623856F, 0.1099732998F, 0.1105857516F, 0.1111997389F, 
  0.1118152597F, 0.1124323121F, 0.1130508939F, 0.1136710032F, 
  0.1142926379F, 0.1149157960F, 0.1155404755F, 0.1161666742F, 
  0.1167943901F, 0.1174236211F, 0.1180543652F, 0.1186866202F, 
  0.1193203841F, 0.1199556548F, 0.1205924300F, 0.1212307078F, 
  0.1218704860F, 0.1225117624F, 0.1231545349F, 0.1237988013F, 
  0.1244445596F, 0.1250918074F, 0.1257405427F, 0.1263907632F, 
  0.1270424667F, 0.1276956512F, 0.1283503142F, 0.1290064537F, 
  0.1296640674F, 0.1303231530F, 0.1309837084F, 0.1316457312F, 
  0.1323092193F, 0.1329741703F, 0.1336405820F, 0.1343084520F, 
  0.1349777782F, 0.1356485582F, 0.1363207897F, 0.1369944704F, 
  0.1376695979F, 0.1383461700F, 0.1390241842F, 0.1397036384F, 
  0.1403845300F, 0.1410668567F, 0.1417506162F, 0.1424358061F, 
  0.1431224240F, 0.1438104674F, 0.1444999341F, 0.1451908216F, 
  0.1458831274F, 0.1465768492F, 0.1472719844F, 0.1479685308F, 
  0.1486664857F, 0.1493658468F, 0.1500666115F, 0.1507687775F, 
  0.1514723422F, 0.1521773031F, 0.1528836577F, 0.1535914035F, 
  0.1543005380F, 0.1550110587F, 0.1557229631F, 0.1564362485F, 
  0.1571509124F, 0.1578669524F, 0.1585843657F, 0.1593031499F, 
  0.1600233024F, 0.1607448205F, 0.1614677017F, 0.1621919433F, 
  0.1629175428F, 0.1636444975F, 0.1643728047F, 0.1651024619F, 
  0.1658334665F, 0.1665658156F, 0.1672995067F, 0.1680345371F, 
  0.1687709041F, 0.1695086050F, 0.1702476372F, 0.1709879978F, 
  0.1717296843F, 0.1724726938F, 0.1732170237F, 0.1739626711F, 
  0.1747096335F, 0.1754579079F, 0.1762074916F, 0.1769583819F, 
  0.1777105760F, 0.1784640710F, 0.1792188642F, 0.1799749529F, 
  0.1807323340F, 0.1814910049F, 0.1822509628F, 0.1830122046F, 
  0.1837747277F, 0.1845385292F, 0.1853036062F, 0.1860699558F, 
  0.1868375751F, 0.1876064613F, 0.1883766114F, 0.1891480226F, 
  0.1899206919F, 0.1906946164F, 0.1914697932F, 0.1922462194F, 
  0.1930238919F, 0.1938028079F, 0.1945829643F, 0.1953643583F, 
  0.1961469868F, 0.1969308468F, 0.1977159353F, 0.1985022494F, 
  0.1992897859F, 0.2000785420F, 0.2008685145F, 0.2016597005F, 
  0.2024520968F, 0.2032457005F, 0.2040405084F, 0.2048365175F, 
  0.2056337247F, 0.2064321269F, 0.2072317211F, 0.2080325041F, 
  0.2088344727F, 0.2096376240F, 0.2104419547F, 0.2112474618F, 
  0.2120541420F, 0.2128619923F, 0.2136710094F, 0.2144811902F, 
  0.2152925315F, 0.2161050301F, 0.2169186829F, 0.2177334866F, 
  0.2185494381F, 0.2193665340F, 0.2201847712F, 0.2210041465F, 
  0.2218246565F, 0.2226462981F, 0.2234690680F, 0.2242929629F, 
  0.2251179796F, 0.2259441147F, 0.2267713650F, 0.2275997272F, 
  0.2284291979F, 0.2292597739F, 0.2300914518F, 0.2309242283F, 
  0.2317581001F, 0.2325930638F, 0.2334291160F, 0.2342662534F, 
  0.2351044727F, 0.2359437703F, 0.2367841431F, 0.2376255875F, 
  0.2384681001F, 0.2393116776F, 0.2401563165F, 0.2410020134F, 
  0.2418487649F, 0.2426965675F, 0.2435454178F, 0.2443953122F, 
  0.2452462474F, 0.2460982199F, 0.2469512262F, 0.2478052628F, 
  0.2486603262F, 0.2495164129F, 0.2503735194F, 0.2512316421F, 
  0.2520907776F, 0.2529509222F, 0.2538120726F, 0.2546742250F, 
  0.2555373760F, 0.2564015219F, 0.2572666593F, 0.2581327845F, 
  0.2589998939F, 0.2598679840F, 0.2607370510F, 0.2616070916F, 
  0.2624781019F, 0.2633500783F, 0.2642230173F, 0.2650969152F, 
  0.2659717684F, 0.2668475731F, 0.2677243257F, 0.2686020226F, 
  0.2694806601F, 0.2703602344F, 0.2712407419F, 0.2721221789F, 
  0.2730045417F, 0.2738878265F, 0.2747720297F, 0.2756571474F, 
  0.2765431760F, 0.2774301117F, 0.2783179508F, 0.2792066895F, 
  0.2800963240F, 0.2809868505F, 0.2818782654F, 0.2827705647F, 
  0.2836637447F, 0.2845578016F, 0.2854527315F, 0.2863485307F, 
  0.2872451953F, 0.2881427215F, 0.2890411055F, 0.2899403433F, 
  0.2908404312F, 0.2917413654F, 0.2926431418F, 0.2935457567F, 
  0.2944492061F, 0.2953534863F, 0.2962585932F, 0.2971645230F, 
  0.2980712717F, 0.2989788356F, 0.2998872105F, 0.3007963927F, 
  0.3017063781F, 0.3026171629F, 0.3035287430F, 0.3044411145F, 
  0.3053542736F, 0.3062682161F, 0.3071829381F, 0.3080984356F, 
  0.3090147047F, 0.3099317413F, 0.3108495414F, 0.3117681011F, 
  0.3126874163F, 0.3136074830F, 0.3145282972F, 0.3154498548F, 
  0.3163721517F, 0.3172951841F, 0.3182189477F, 0.3191434385F, 
  0.3200686525F, 0.3209945856F, 0.3219212336F, 0.3228485927F, 
  0.3237766585F, 0.3247054271F, 0.3256348943F, 0.3265650560F, 
  0.3274959081F, 0.3284274465F, 0.3293596671F, 0.3302925657F, 
  0.3312261382F, 0.3321603804F, 0.3330952882F, 0.3340308574F, 
  0.3349670838F, 0.3359039634F, 0.3368414919F, 0.3377796651F, 
  0.3387184789F, 0.3396579290F, 0.3405980113F, 0.3415387216F, 
  0.3424800556F, 0.3434220091F, 0.3443645779F, 0.3453077578F, 
  0.3462515446F, 0.3471959340F, 0.3481409217F, 0.3490865036F, 
  0.3500326754F, 0.3509794328F, 0.3519267715F, 0.3528746873F, 
  0.3538231759F, 0.3547722330F, 0.3557218544F, 0.3566720357F, 
  0.3576227727F, 0.3585740610F, 0.3595258964F, 0.3604782745F, 
  0.3614311910F, 0.3623846417F, 0.3633386221F, 0.3642931280F, 
  0.3652481549F, 0.3662036987F, 0.3671597548F, 0.3681163191F, 
  0.3690733870F, 0.3700309544F, 0.3709890167F, 0.3719475696F, 
  0.3729066089F, 0.3738661299F, 0.3748261285F, 0.3757866002F, 
  0.3767475406F, 0.3777089453F, 0.3786708100F, 0.3796331302F, 
  0.3805959014F, 0.3815591194F, 0.3825227796F, 0.3834868777F, 
  0.3844514093F, 0.3854163698F, 0.3863817549F, 0.3873475601F, 
  0.3883137810F, 0.3892804131F, 0.3902474521F, 0.3912148933F, 
  0.3921827325F, 0.3931509650F, 0.3941195865F, 0.3950885925F, 
  0.3960579785F, 0.3970277400F, 0.3979978725F, 0.3989683716F, 
  0.3999392328F, 0.4009104516F, 0.4018820234F, 0.4028539438F, 
  0.4038262084F, 0.4047988125F, 0.4057717516F, 0.4067450214F, 
  0.4077186172F, 0.4086925345F, 0.4096667688F, 0.4106413155F, 
  0.4116161703F, 0.4125913284F, 0.4135667854F, 0.4145425368F, 
  0.4155185780F, 0.4164949044F, 0.4174715116F, 0.4184483949F, 
  0.4194255498F, 0.4204029718F, 0.4213806563F, 0.4223585987F, 
  0.4233367946F, 0.4243152392F, 0.4252939281F, 0.4262728566F, 
  0.4272520202F, 0.4282314144F, 0.4292110345F, 0.4301908760F, 
  0.4311709343F, 0.4321512047F, 0.4331316828F, 0.4341123639F, 
  0.4350932435F, 0.4360743168F, 0.4370555794F, 0.4380370267F, 
  0.4390186540F, 0.4400004567F, 0.4409824303F, 0.4419645701F, 
  0.4429468716F, 0.4439293300F, 0.4449119409F, 0.4458946996F, 
  0.4468776014F, 0.4478606418F, 0.4488438162F, 0.4498271199F, 
  0.4508105483F, 0.4517940967F, 0.4527777607F, 0.4537615355F, 
  0.4547454165F, 0.4557293991F, 0.4567134786F, 0.4576976505F, 
  0.4586819101F, 0.4596662527F, 0.4606506738F, 0.4616351687F, 
  0.4626197328F, 0.4636043614F, 0.4645890499F, 0.4655737936F, 
  0.4665585880F, 0.4675434284F, 0.4685283101F, 0.4695132286F, 
  0.4704981791F, 0.4714831570F, 0.4724681577F, 0.4734531766F, 
  0.4744382089F, 0.4754232501F, 0.4764082956F, 0.4773933406F, 
  0.4783783806F, 0.4793634108F, 0.4803484267F, 0.4813334237F, 
  0.4823183969F, 0.4833033419F, 0.4842882540F, 0.4852731285F, 
  0.4862579608F, 0.4872427462F, 0.4882274802F, 0.4892121580F, 
  0.4901967751F, 0.4911813267F, 0.4921658083F, 0.4931502151F, 
  0.4941345427F, 0.4951187863F, 0.4961029412F, 0.4970870029F, 
  0.4980709667F, 0.4990548280F, 0.5000385822F, 0.5010222245F, 
  0.5020057505F, 0.5029891553F, 0.5039724345F, 0.5049555834F, 
  0.5059385973F, 0.5069214716F, 0.5079042018F, 0.5088867831F, 
  0.5098692110F, 0.5108514808F, 0.5118335879F, 0.5128155277F, 
  0.5137972956F, 0.5147788869F, 0.5157602971F, 0.5167415215F, 
  0.5177225555F, 0.5187033945F, 0.5196840339F, 0.5206644692F, 
  0.5216446956F, 0.5226247086F, 0.5236045035F, 0.5245840759F, 
  0.5255634211F, 0.5265425344F, 0.5275214114F, 0.5285000474F, 
  0.5294784378F, 0.5304565781F, 0.5314344637F, 0.5324120899F, 
  0.5333894522F, 0.5343665461F, 0.5353433670F, 0.5363199102F, 
  0.5372961713F, 0.5382721457F, 0.5392478287F, 0.5402232159F, 
  0.5411983027F, 0.5421730845F, 0.5431475569F, 0.5441217151F, 
  0.5450955548F, 0.5460690714F, 0.5470422602F, 0.5480151169F, 
  0.5489876368F, 0.5499598155F, 0.5509316484F, 0.5519031310F, 
  0.5528742587F, 0.5538450271F, 0.5548154317F, 0.5557854680F, 
  0.5567551314F, 0.5577244174F, 0.5586933216F, 0.5596618395F, 
  0.5606299665F, 0.5615976983F, 0.5625650302F, 0.5635319580F, 
  0.5644984770F, 0.5654645828F, 0.5664302709F, 0.5673955370F, 
  0.5683603765F, 0.5693247850F, 0.5702887580F, 0.5712522912F, 
  0.5722153800F, 0.5731780200F, 0.5741402069F, 0.5751019362F, 
  0.5760632034F, 0.5770240042F, 0.5779843341F, 0.5789441889F, 
  0.5799035639F, 0.5808624549F, 0.5818208575F, 0.5827787673F, 
  0.5837361800F, 0.5846930910F, 0.5856494961F, 0.5866053910F, 
  0.5875607712F, 0.5885156324F, 0.5894699703F, 0.5904237804F, 
  0.5913770586F, 0.5923298004F, 0.5932820016F, 0.5942336578F, 
  0.5951847646F, 0.5961353179F, 0.5970853132F, 0.5980347464F, 
  0.5989836131F, 0.5999319090F, 0.6008796298F, 0.6018267713F, 
  0.6027733292F, 0.6037192993F, 0.6046646773F, 0.6056094589F, 
  0.6065536400F, 0.6074972162F, 0.6084401833F, 0.6093825372F, 
  0.6103242736F, 0.6112653884F, 0.6122058772F, 0.6131457359F, 
  0.6140849604F, 0.6150235464F, 0.6159614897F, 0.6168987862F, 
  0.6178354318F, 0.6187714223F, 0.6197067535F, 0.6206414213F, 
  0.6215754215F, 0.6225087501F, 0.6234414028F, 0.6243733757F, 
  0.6253046646F, 0.6262352654F, 0.6271651739F, 0.6280943862F, 
  0.6290228982F, 0.6299507057F, 0.6308778048F, 0.6318041913F, 
  0.6327298612F, 0.6336548105F, 0.6345790352F, 0.6355025312F, 
  0.6364252945F, 0.6373473211F, 0.6382686070F, 0.6391891483F, 
  0.6401089409F, 0.6410279808F, 0.6419462642F, 0.6428637869F, 
  0.6437805452F, 0.6446965350F, 0.6456117524F, 0.6465261935F, 
  0.6474398544F, 0.6483527311F, 0.6492648197F, 0.6501761165F, 
  0.6510866174F, 0.6519963186F, 0.6529052162F, 0.6538133064F, 
  0.6547205854F, 0.6556270492F, 0.6565326941F, 0.6574375162F, 
  0.6583415117F, 0.6592446769F, 0.6601470079F, 0.6610485009F, 
  0.6619491521F, 0.6628489578F, 0.6637479143F, 0.6646460177F, 
  0.6655432643F, 0.6664396505F, 0.6673351724F, 0.6682298264F, 
  0.6691236087F, 0.6700165157F, 0.6709085436F, 0.6717996889F, 
  0.6726899478F, 0.6735793167F, 0.6744677918F, 0.6753553697F, 
  0.6762420466F, 0.6771278190F, 0.6780126832F, 0.6788966357F, 
  0.6797796728F, 0.6806617909F, 0.6815429866F, 0.6824232562F, 
  0.6833025961F, 0.6841810030F, 0.6850584731F, 0.6859350031F, 
  0.6868105894F, 0.6876852284F, 0.6885589168F, 0.6894316510F, 
  0.6903034275F, 0.6911742430F, 0.6920440939F, 0.6929129769F, 
  0.6937808884F, 0.6946478251F, 0.6955137837F, 0.6963787606F, 
  0.6972427525F, 0.6981057560F, 0.6989677678F, 0.6998287845F, 
  0.7006888028F, 0.7015478194F, 0.7024058309F, 0.7032628340F, 
  0.7041188254F, 0.7049738019F, 0.7058277601F, 0.7066806969F, 
  0.7075326089F, 0.7083834929F, 0.7092333457F, 0.7100821640F, 
  0.7109299447F, 0.7117766846F, 0.7126223804F, 0.7134670291F, 
  0.7143106273F, 0.7151531721F, 0.7159946602F, 0.7168350885F, 
  0.7176744539F, 0.7185127534F, 0.7193499837F, 0.7201861418F, 
  0.7210212247F, 0.7218552293F, 0.7226881526F, 0.7235199914F, 
  0.7243507428F, 0.7251804039F, 0.7260089715F, 0.7268364426F, 
  0.7276628144F, 0.7284880839F, 0.7293122481F, 0.7301353040F, 
  0.7309572487F, 0.7317780794F, 0.7325977930F, 0.7334163868F, 
  0.7342338579F, 0.7350502033F, 0.7358654202F, 0.7366795059F, 
  0.7374924573F, 0.7383042718F, 0.7391149465F, 0.7399244787F, 
  0.7407328655F, 0.7415401041F, 0.7423461920F, 0.7431511261F, 
  0.7439549040F, 0.7447575227F, 0.7455589797F, 0.7463592723F, 
  0.7471583976F, 0.7479563532F, 0.7487531363F, 0.7495487443F, 
  0.7503431745F, 0.7511364244F, 0.7519284913F, 0.7527193726F, 
  0.7535090658F, 0.7542975683F, 0.7550848776F, 0.7558709910F, 
  0.7566559062F, 0.7574396205F, 0.7582221314F, 0.7590034366F, 
  0.7597835334F, 0.7605624194F, 0.7613400923F, 0.7621165495F, 
  0.7628917886F, 0.7636658072F, 0.7644386030F, 0.7652101735F, 
  0.7659805164F, 0.7667496292F, 0.7675175098F, 0.7682841556F, 
  0.7690495645F, 0.7698137341F, 0.7705766622F, 0.7713383463F, 
  0.7720987844F, 0.7728579741F, 0.7736159132F, 0.7743725994F, 
  0.7751280306F, 0.7758822046F, 0.7766351192F, 0.7773867722F, 
  0.7781371614F, 0.7788862848F, 0.7796341401F, 0.7803807253F, 
  0.7811260383F, 0.7818700769F, 0.7826128392F, 0.7833543230F, 
  0.7840945263F, 0.7848334471F, 0.7855710833F, 0.7863074330F, 
  0.7870424941F, 0.7877762647F, 0.7885087428F, 0.7892399264F, 
  0.7899698137F, 0.7906984026F, 0.7914256914F, 0.7921516780F, 
  0.7928763607F, 0.7935997375F, 0.7943218065F, 0.7950425661F, 
  0.7957620142F, 0.7964801492F, 0.7971969692F, 0.7979124724F, 
  0.7986266570F, 0.7993395214F, 0.8000510638F, 0.8007612823F, 
  0.8014701754F, 0.8021777413F, 0.8028839784F, 0.8035888849F, 
  0.8042924592F, 0.8049946997F, 0.8056956048F, 0.8063951727F, 
  0.8070934020F, 0.8077902910F, 0.8084858381F, 0.8091800419F, 
  0.8098729007F, 0.8105644130F, 0.8112545774F, 0.8119433922F, 
  0.8126308561F, 0.8133169676F, 0.8140017251F, 0.8146851272F, 
  0.8153671726F, 0.8160478598F, 0.8167271874F, 0.8174051539F, 
  0.8180817582F, 0.8187569986F, 0.8194308741F, 0.8201033831F, 
  0.8207745244F, 0.8214442966F, 0.8221126986F, 0.8227797290F, 
  0.8234453865F, 0.8241096700F, 0.8247725781F, 0.8254341097F, 
  0.8260942636F, 0.8267530385F, 0.8274104334F, 0.8280664470F, 
  0.8287210782F, 0.8293743259F, 0.8300261889F, 0.8306766662F, 
  0.8313257566F, 0.8319734591F, 0.8326197727F, 0.8332646963F, 
  0.8339082288F, 0.8345503692F, 0.8351911167F, 0.8358304700F, 
  0.8364684284F, 0.8371049907F, 0.8377401562F, 0.8383739238F, 
  0.8390062927F, 0.8396372618F, 0.8402668305F, 0.8408949977F, 
  0.8415217626F, 0.8421471245F, 0.8427710823F, 0.8433936354F, 
  0.8440147830F, 0.8446345242F, 0.8452528582F, 0.8458697844F, 
  0.8464853020F, 0.8470994102F, 0.8477121084F, 0.8483233958F, 
  0.8489332718F, 0.8495417356F, 0.8501487866F, 0.8507544243F, 
  0.8513586479F, 0.8519614568F, 0.8525628505F, 0.8531628283F, 
  0.8537613897F, 0.8543585341F, 0.8549542611F, 0.8555485699F, 
  0.8561414603F, 0.8567329315F, 0.8573229832F, 0.8579116149F, 
  0.8584988262F, 0.8590846165F, 0.8596689855F, 0.8602519327F, 
  0.8608334577F, 0.8614135603F, 0.8619922399F, 0.8625694962F, 
  0.8631453289F, 0.8637197377F, 0.8642927222F, 0.8648642821F, 
  0.8654344172F, 0.8660031272F, 0.8665704118F, 0.8671362708F, 
  0.8677007039F, 0.8682637109F, 0.8688252917F, 0.8693854460F, 
  0.8699441737F, 0.8705014745F, 0.8710573485F, 0.8716117953F, 
  0.8721648150F, 0.8727164073F, 0.8732665723F, 0.8738153098F, 
  0.8743626197F, 0.8749085021F, 0.8754529569F, 0.8759959840F, 
  0.8765375835F, 0.8770777553F, 0.8776164996F, 0.8781538162F, 
  0.8786897054F, 0.8792241670F, 0.8797572013F, 0.8802888082F, 
  0.8808189880F, 0.8813477407F, 0.8818750664F, 0.8824009653F, 
  0.8829254375F, 0.8834484833F, 0.8839701028F, 0.8844902961F, 
  0.8850090636F, 0.8855264054F, 0.8860423218F, 0.8865568131F, 
  0.8870698794F, 0.8875815212F, 0.8880917386F, 0.8886005319F, 
  0.8891079016F, 0.8896138479F, 0.8901183712F, 0.8906214719F, 
  0.8911231503F, 0.8916234067F, 0.8921222417F, 0.8926196556F, 
  0.8931156489F, 0.8936102219F, 0.8941033752F, 0.8945951092F, 
  0.8950854244F, 0.8955743212F, 0.8960618003F, 0.8965478621F, 
  0.8970325071F, 0.8975157359F, 0.8979975490F, 0.8984779471F, 
  0.8989569307F, 0.8994345004F, 0.8999106568F, 0.9003854005F, 
  0.9008587323F, 0.9013306526F, 0.9018011623F, 0.9022702619F, 
  0.9027379521F, 0.9032042337F, 0.9036691074F, 0.9041325739F, 
  0.9045946339F, 0.9050552882F, 0.9055145376F, 0.9059723828F, 
  0.9064288246F, 0.9068838638F, 0.9073375013F, 0.9077897379F, 
  0.9082405743F, 0.9086900115F, 0.9091380503F, 0.9095846917F, 
  0.9100299364F, 0.9104737854F, 0.9109162397F, 0.9113573001F, 
  0.9117969675F, 0.9122352430F, 0.9126721275F, 0.9131076219F, 
  0.9135417273F, 0.9139744447F, 0.9144057750F, 0.9148357194F, 
  0.9152642787F, 0.9156914542F, 0.9161172468F, 0.9165416576F, 
  0.9169646877F, 0.9173863382F, 0.9178066102F, 0.9182255048F, 
  0.9186430232F, 0.9190591665F, 0.9194739359F, 0.9198873324F, 
  0.9202993574F, 0.9207100120F, 0.9211192973F, 0.9215272147F, 
  0.9219337653F, 0.9223389504F, 0.9227427713F, 0.9231452290F, 
  0.9235463251F, 0.9239460607F, 0.9243444371F, 0.9247414557F, 
  0.9251371177F, 0.9255314245F, 0.9259243774F, 0.9263159778F, 
  0.9267062270F, 0.9270951264F, 0.9274826774F, 0.9278688814F, 
  0.9282537398F, 0.9286372540F, 0.9290194254F, 0.9294002555F, 
  0.9297797458F, 0.9301578976F, 0.9305347125F, 0.9309101919F, 
  0.9312843373F, 0.9316571503F, 0.9320286323F, 0.9323987849F, 
  0.9327676097F, 0.9331351080F, 0.9335012816F, 0.9338661320F, 
  0.9342296607F, 0.9345918694F, 0.9349527596F, 0.9353123330F, 
  0.9356705911F, 0.9360275357F, 0.9363831683F, 0.9367374905F, 
  0.9370905042F, 0.9374422108F, 0.9377926122F, 0.9381417099F, 
  0.9384895057F, 0.9388360014F, 0.9391811985F, 0.9395250989F, 
  0.9398677043F, 0.9402090165F, 0.9405490371F, 0.9408877680F, 
  0.9412252110F, 0.9415613678F, 0.9418962402F, 0.9422298301F, 
  0.9425621392F, 0.9428931695F, 0.9432229226F, 0.9435514005F, 
  0.9438786050F, 0.9442045381F, 0.9445292014F, 0.9448525971F, 
  0.9451747268F, 0.9454955926F, 0.9458151963F, 0.9461335399F, 
  0.9464506253F, 0.9467664545F, 0.9470810293F, 0.9473943517F, 
  0.9477064238F, 0.9480172474F, 0.9483268246F, 0.9486351573F, 
  0.9489422475F, 0.9492480973F, 0.9495527087F, 0.9498560837F, 
  0.9501582243F, 0.9504591325F, 0.9507588105F, 0.9510572603F, 
  0.9513544839F, 0.9516504834F, 0.9519452609F, 0.9522388186F, 
  0.9525311584F, 0.9528222826F, 0.9531121932F, 0.9534008923F, 
  0.9536883821F, 0.9539746647F, 0.9542597424F, 0.9545436171F, 
  0.9548262912F, 0.9551077667F, 0.9553880459F, 0.9556671309F, 
  0.9559450239F, 0.9562217272F, 0.9564972429F, 0.9567715733F, 
  0.9570447206F, 0.9573166871F, 0.9575874749F, 0.9578570863F, 
  0.9581255236F, 0.9583927890F, 0.9586588849F, 0.9589238134F, 
  0.9591875769F, 0.9594501777F, 0.9597116180F, 0.9599719003F, 
  0.9602310267F, 0.9604889995F, 0.9607458213F, 0.9610014942F, 
  0.9612560206F, 0.9615094028F, 0.9617616433F, 0.9620127443F, 
  0.9622627083F, 0.9625115376F, 0.9627592345F, 0.9630058016F, 
  0.9632512411F, 0.9634955555F, 0.9637387471F, 0.9639808185F, 
  0.9642217720F, 0.9644616100F, 0.9647003349F, 0.9649379493F, 
  0.9651744556F, 0.9654098561F, 0.9656441534F, 0.9658773499F, 
  0.9661094480F, 0.9663404504F, 0.9665703593F, 0.9667991774F, 
  0.9670269071F, 0.9672535509F, 0.9674791114F, 0.9677035909F, 
  0.9679269921F, 0.9681493174F, 0.9683705694F, 0.9685907506F, 
  0.9688098636F, 0.9690279108F, 0.9692448948F, 0.9694608182F, 
  0.9696756836F, 0.9698894934F, 0.9701022503F, 0.9703139569F, 
  0.9705246156F, 0.9707342291F, 0.9709428000F, 0.9711503309F, 
  0.9713568243F, 0.9715622829F, 0.9717667093F, 0.9719701060F, 
  0.9721724757F, 0.9723738210F, 0.9725741446F, 0.9727734490F, 
  0.9729717369F, 0.9731690109F, 0.9733652737F, 0.9735605279F, 
  0.9737547762F, 0.9739480212F, 0.9741402656F, 0.9743315120F, 
  0.9745217631F, 0.9747110216F, 0.9748992901F, 0.9750865714F, 
  0.9752728681F, 0.9754581829F, 0.9756425184F, 0.9758258775F, 
  0.9760082627F, 0.9761896768F, 0.9763701224F, 0.9765496024F, 
  0.9767281193F, 0.9769056760F, 0.9770822751F, 0.9772579193F, 
  0.9774326114F, 0.9776063542F, 0.9777791502F, 0.9779510023F, 
  0.9781219133F, 0.9782918858F, 0.9784609226F, 0.9786290264F, 
  0.9787962000F, 0.9789624461F, 0.9791277676F, 0.9792921671F, 
  0.9794556474F, 0.9796182113F, 0.9797798615F, 0.9799406009F, 
  0.9801004321F, 0.9802593580F, 0.9804173813F, 0.9805745049F, 
  0.9807307314F, 0.9808860637F, 0.9810405046F, 0.9811940568F, 
  0.9813467232F, 0.9814985065F, 0.9816494095F, 0.9817994351F, 
  0.9819485860F, 0.9820968650F, 0.9822442750F, 0.9823908186F, 
  0.9825364988F, 0.9826813184F, 0.9828252801F, 0.9829683868F, 
  0.9831106413F, 0.9832520463F, 0.9833926048F, 0.9835323195F, 
  0.9836711932F, 0.9838092288F, 0.9839464291F, 0.9840827969F, 
  0.9842183351F, 0.9843530464F, 0.9844869337F, 0.9846199998F, 
  0.9847522475F, 0.9848836798F, 0.9850142993F, 0.9851441090F, 
  0.9852731117F, 0.9854013101F, 0.9855287073F, 0.9856553058F, 
  0.9857811087F, 0.9859061188F, 0.9860303388F, 0.9861537717F, 
  0.9862764202F, 0.9863982872F, 0.9865193756F, 0.9866396882F, 
  0.9867592277F, 0.9868779972F, 0.9869959993F, 0.9871132370F, 
  0.9872297131F, 0.9873454304F, 0.9874603918F, 0.9875746001F, 
  0.9876880581F, 0.9878007688F, 0.9879127348F, 0.9880239592F, 
  0.9881344447F, 0.9882441941F, 0.9883532104F, 0.9884614962F, 
  0.9885690546F, 0.9886758883F, 0.9887820001F, 0.9888873930F, 
  0.9889920697F, 0.9890960331F, 0.9891992859F, 0.9893018312F, 
  0.9894036716F, 0.9895048100F, 0.9896052493F, 0.9897049923F, 
  0.9898040418F, 0.9899024006F, 0.9900000717F, 0.9900970577F, 
  0.9901933616F, 0.9902889862F, 0.9903839343F, 0.9904782087F, 
  0.9905718122F, 0.9906647477F, 0.9907570180F, 0.9908486259F, 
  0.9909395742F, 0.9910298658F, 0.9911195034F, 0.9912084899F, 
  0.9912968281F, 0.9913845208F, 0.9914715708F, 0.9915579810F, 
  0.9916437540F, 0.9917288928F, 0.9918134001F, 0.9918972788F, 
  0.9919805316F, 0.9920631613F, 0.9921451707F, 0.9922265626F, 
  0.9923073399F, 0.9923875052F, 0.9924670615F, 0.9925460114F, 
  0.9926243577F, 0.9927021033F, 0.9927792508F, 0.9928558032F, 
  0.9929317631F, 0.9930071333F, 0.9930819167F, 0.9931561158F, 
  0.9932297337F, 0.9933027728F, 0.9933752362F, 0.9934471264F, 
  0.9935184462F, 0.9935891985F, 0.9936593859F, 0.9937290112F, 
  0.9937980771F, 0.9938665864F, 0.9939345418F, 0.9940019460F, 
  0.9940688018F, 0.9941351118F, 0.9942008789F, 0.9942661057F, 
  0.9943307950F, 0.9943949494F, 0.9944585717F, 0.9945216645F, 
  0.9945842307F, 0.9946462728F, 0.9947077936F, 0.9947687957F, 
  0.9948292820F, 0.9948892550F, 0.9949487174F, 0.9950076719F, 
  0.9950661212F, 0.9951240679F, 0.9951815148F, 0.9952384645F, 
  0.9952949196F, 0.9953508828F, 0.9954063568F, 0.9954613442F, 
  0.9955158476F, 0.9955698697F, 0.9956234132F, 0.9956764806F, 
  0.9957290746F, 0.9957811978F, 0.9958328528F, 0.9958840423F, 
  0.9959347688F, 0.9959850351F, 0.9960348435F, 0.9960841969F, 
  0.9961330977F, 0.9961815486F, 0.9962295521F, 0.9962771108F, 
  0.9963242274F, 0.9963709043F, 0.9964171441F, 0.9964629494F, 
  0.9965083228F, 0.9965532668F, 0.9965977840F, 0.9966418768F, 
  0.9966855479F, 0.9967287998F, 0.9967716350F, 0.9968140559F, 
  0.9968560653F, 0.9968976655F, 0.9969388591F, 0.9969796485F, 
  0.9970200363F, 0.9970600250F, 0.9970996170F, 0.9971388149F, 
  0.9971776211F, 0.9972160380F, 0.9972540683F, 0.9972917142F, 
  0.9973289783F, 0.9973658631F, 0.9974023709F, 0.9974385042F, 
  0.9974742655F, 0.9975096571F, 0.9975446816F, 0.9975793413F, 
  0.9976136386F, 0.9976475759F, 0.9976811557F, 0.9977143803F, 
  0.9977472521F, 0.9977797736F, 0.9978119470F, 0.9978437748F, 
  0.9978752593F, 0.9979064029F, 0.9979372079F, 0.9979676768F, 
  0.9979978117F, 0.9980276151F, 0.9980570893F, 0.9980862367F, 
  0.9981150595F, 0.9981435600F, 0.9981717406F, 0.9981996035F, 
  0.9982271511F, 0.9982543856F, 0.9982813093F, 0.9983079246F, 
  0.9983342336F, 0.9983602386F, 0.9983859418F, 0.9984113456F, 
  0.9984364522F, 0.9984612638F, 0.9984857825F, 0.9985100108F, 
  0.9985339507F, 0.9985576044F, 0.9985809743F, 0.9986040624F, 
  0.9986268710F, 0.9986494022F, 0.9986716583F, 0.9986936413F, 
  0.9987153535F, 0.9987367969F, 0.9987579738F, 0.9987788864F, 
  0.9987995366F, 0.9988199267F, 0.9988400587F, 0.9988599348F, 
  0.9988795572F, 0.9988989278F, 0.9989180487F, 0.9989369222F, 
  0.9989555501F, 0.9989739347F, 0.9989920780F, 0.9990099820F, 
  0.9990276487F, 0.9990450803F, 0.9990622787F, 0.9990792460F, 
  0.9990959841F, 0.9991124952F, 0.9991287812F, 0.9991448440F, 
  0.9991606858F, 0.9991763084F, 0.9991917139F, 0.9992069042F, 
  0.9992218813F, 0.9992366471F, 0.9992512035F, 0.9992655525F, 
  0.9992796961F, 0.9992936361F, 0.9993073744F, 0.9993209131F, 
  0.9993342538F, 0.9993473987F, 0.9993603494F, 0.9993731080F, 
  0.9993856762F, 0.9993980559F, 0.9994102490F, 0.9994222573F, 
  0.9994340827F, 0.9994457269F, 0.9994571918F, 0.9994684793F, 
  0.9994795910F, 0.9994905288F, 0.9995012945F, 0.9995118898F, 
  0.9995223165F, 0.9995325765F, 0.9995426713F, 0.9995526029F, 
  0.9995623728F, 0.9995719829F, 0.9995814349F, 0.9995907304F, 
  0.9995998712F, 0.9996088590F, 0.9996176954F, 0.9996263821F, 
  0.9996349208F, 0.9996433132F, 0.9996515609F, 0.9996596656F, 
  0.9996676288F, 0.9996754522F, 0.9996831375F, 0.9996906862F, 
  0.9996981000F, 0.9997053804F, 0.9997125290F, 0.9997195474F, 
  0.9997264371F, 0.9997331998F, 0.9997398369F, 0.9997463500F, 
  0.9997527406F, 0.9997590103F, 0.9997651606F, 0.9997711930F, 
  0.9997771089F, 0.9997829098F, 0.9997885973F, 0.9997941728F, 
  0.9997996378F, 0.9998049936F, 0.9998102419F, 0.9998153839F, 
  0.9998204211F, 0.9998253550F, 0.9998301868F, 0.9998349182F, 
  0.9998395503F, 0.9998440847F, 0.9998485226F, 0.9998528654F, 
  0.9998571146F, 0.9998612713F, 0.9998653370F, 0.9998693130F, 
  0.9998732007F, 0.9998770012F, 0.9998807159F, 0.9998843461F, 
  0.9998878931F, 0.9998913581F, 0.9998947424F, 0.9998980473F, 
  0.9999012740F, 0.9999044237F, 0.9999074976F, 0.9999104971F, 
  0.9999134231F, 0.9999162771F, 0.9999190601F, 0.9999217733F, 
  0.9999244179F, 0.9999269950F, 0.9999295058F, 0.9999319515F, 
  0.9999343332F, 0.9999366519F, 0.9999389088F, 0.9999411050F, 
  0.9999432416F, 0.9999453196F, 0.9999473402F, 0.9999493044F, 
  0.9999512132F, 0.9999530677F, 0.9999548690F, 0.9999566180F, 
  0.9999583157F, 0.9999599633F, 0.9999615616F, 0.9999631116F, 
  0.9999646144F, 0.9999660709F, 0.9999674820F, 0.9999688487F, 
  0.9999701719F, 0.9999714526F, 0.9999726917F, 0.9999738900F, 
  0.9999750486F, 0.9999761682F, 0.9999772497F, 0.9999782941F, 
  0.9999793021F, 0.9999802747F, 0.9999812126F, 0.9999821167F, 
  0.9999829878F, 0.9999838268F, 0.9999846343F, 0.9999854113F, 
  0.9999861584F, 0.9999868765F, 0.9999875664F, 0.9999882287F, 
  0.9999888642F, 0.9999894736F, 0.9999900577F, 0.9999906172F, 
  0.9999911528F, 0.9999916651F, 0.9999921548F, 0.9999926227F, 
  0.9999930693F, 0.9999934954F, 0.9999939015F, 0.9999942883F, 
  0.9999946564F, 0.9999950064F, 0.9999953390F, 0.9999956547F, 
  0.9999959541F, 0.9999962377F, 0.9999965062F, 0.9999967601F, 
  0.9999969998F, 0.9999972260F, 0.9999974392F, 0.9999976399F, 
  0.9999978285F, 0.9999980056F, 0.9999981716F, 0.9999983271F, 
  0.9999984724F, 0.9999986081F, 0.9999987345F, 0.9999988521F, 
  0.9999989613F, 0.9999990625F, 0.9999991562F, 0.9999992426F, 
  0.9999993223F, 0.9999993954F, 0.9999994625F, 0.9999995239F, 
  0.9999995798F, 0.9999996307F, 0.9999996768F, 0.9999997184F, 
  0.9999997559F, 0.9999997895F, 0.9999998195F, 0.9999998462F, 
  0.9999998698F, 0.9999998906F, 0.9999999088F, 0.9999999246F, 
  0.9999999383F, 0.9999999500F, 0.9999999600F, 0.9999999684F, 
  0.9999999754F, 0.9999999811F, 0.9999999858F, 0.9999999896F, 
  0.9999999925F, 0.9999999948F, 0.9999999965F, 0.9999999978F, 
  0.9999999986F, 0.9999999992F, 0.9999999996F, 0.9999999998F, 
  0.9999999999F, 1.0000000000F, 1.0000000000F, 1.0000000000F, 
};

