/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis 'TREMOR' CODEC SOURCE CODE.   *
 *                                                                  *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis 'TREMOR' SOURCE CODE IS (C) COPYRIGHT 1994-2002    *
 * BY THE Xiph.Org FOUNDATION http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: sin,cos lookup tables

 ********************************************************************/

#include "ogg/os_types.h"

/* {sin(i*PI/2048), cos(i*PI/2048)}, with i = 0 to 512 */
// matlab generated values
static float fsincos_lookup0[1026] =
{
	0.0000000000f,1.00000000f,0.0015339802f,0.99999882f,
	0.0030679568f,0.99999529f,0.0046019261f,0.99998941f,
	0.0061358846f,0.99998118f,0.0076698287f,0.99997059f,
	0.0092037548f,0.99995764f,0.0107376590f,0.99994235f,
	0.0122715380f,0.99992470f,0.0138053890f,0.99990470f,
	0.0153392060f,0.99988235f,0.0168729880f,0.99985764f,
	0.0184067300f,0.99983058f,0.0199404290f,0.99980117f,
	0.0214740800f,0.99976941f,0.0230076810f,0.99973529f,
	0.0245412290f,0.99969882f,0.0260747180f,0.99966000f,
	0.0276081460f,0.99961882f,0.0291415090f,0.99957530f,
	0.0306748030f,0.99952942f,0.0322080250f,0.99948119f,
	0.0337411720f,0.99943060f,0.0352742390f,0.99937767f,
	0.0368072230f,0.99932238f,0.0383401200f,0.99926475f,
	0.0398729280f,0.99920476f,0.0414056410f,0.99914242f,
	0.0429382570f,0.99907773f,0.0444707720f,0.99901069f,
	0.0460031820f,0.99894129f,0.0475354840f,0.99886955f,
	0.0490676740f,0.99879546f,0.0505997490f,0.99871901f,
	0.0521317050f,0.99864022f,0.0536635380f,0.99855907f,
	0.0551952440f,0.99847558f,0.0567268210f,0.99838974f,
	0.0582582650f,0.99830154f,0.0597895710f,0.99821100f,
	0.0613207360f,0.99811811f,0.0628517580f,0.99802287f,
	0.0643826310f,0.99792529f,0.0659133530f,0.99782535f,
	0.0674439200f,0.99772307f,0.0689743280f,0.99761844f,
	0.0705045730f,0.99751146f,0.0720346530f,0.99740213f,
	0.0735645640f,0.99729046f,0.0750943010f,0.99717644f,
	0.0766238610f,0.99706007f,0.0781532420f,0.99694136f,
	0.0796824380f,0.99682030f,0.0812114470f,0.99669690f,
	0.0827402650f,0.99657115f,0.0842688880f,0.99644305f,
	0.0857973120f,0.99631261f,0.0873255350f,0.99617983f,
	0.0888535530f,0.99604470f,0.0903813610f,0.99590723f,
	0.0919089560f,0.99576741f,0.0934363360f,0.99562526f,
	0.0949634950f,0.99548076f,0.0964904310f,0.99533391f,
	0.0980171400f,0.99518473f,0.0995436190f,0.9950332f,
	0.1010698600f,0.99487933f,0.1025958700f,0.99472312f,
	0.1041216300f,0.99456457f,0.1056471500f,0.99440368f,
	0.1071724200f,0.99424045f,0.1086974400f,0.99407488f,
	0.1102222100f,0.99390697f,0.1117467100f,0.99373672f,
	0.1132709500f,0.99356414f,0.1147949300f,0.99338921f,
	0.1163186300f,0.99321195f,0.1178420600f,0.99303235f,
	0.1193652100f,0.99285041f,0.1208880900f,0.99266614f,
	0.1224106800f,0.99247953f,0.1239329800f,0.99229059f,
	0.1254549800f,0.99209931f,0.1269767000f,0.9919057f,
	0.1284981100f,0.99170975f,0.1300192200f,0.99151147f,
	0.1315400300f,0.99131086f,0.1330605300f,0.99110791f,
	0.1345807100f,0.99090264f,0.1361005800f,0.99069503f,
	0.1376201200f,0.99048508f,0.1391393400f,0.99027281f,
	0.1406582400f,0.99005821f,0.1421768000f,0.98984128f,
	0.1436950300f,0.98962202f,0.1452129200f,0.98940043f,
	0.1467304700f,0.98917651f,0.1482476800f,0.98895026f,
	0.1497645300f,0.98872169f,0.1512810400f,0.98849079f,
	0.1527971900f,0.98825757f,0.1543129700f,0.98802202f,
	0.1558284000f,0.98778414f,0.1573434600f,0.98754394f,
	0.1588581400f,0.98730142f,0.1603724600f,0.98705657f,
	0.1618863900f,0.98680940f,0.1633999500f,0.98655991f,
	0.1649131200f,0.98630810f,0.1664259000f,0.98605396f,
	0.1679382900f,0.98579751f,0.1694502900f,0.98553874f,
	0.1709618900f,0.98527764f,0.1724730800f,0.98501423f,
	0.1739838700f,0.98474850f,0.1754942500f,0.98448046f,
	0.1770042200f,0.98421009f,0.1785137700f,0.98393741f,
	0.1800229000f,0.98366242f,0.1815316100f,0.98338511f,
	0.1830398900f,0.98310549f,0.1845477400f,0.98282355f,
	0.1860551500f,0.98253930f,0.1875621300f,0.98225274f,
	0.1890686600f,0.98196387f,0.1905747500f,0.98167269f,
	0.1920804000f,0.98137919f,0.1935855900f,0.98108339f,
	0.1950903200f,0.98078528f,0.1965946000f,0.98048486f,
	0.1980984100f,0.98018214f,0.1996017600f,0.9798771f,
	0.2011046300f,0.97956977f,0.2026070400f,0.97926012f,
	0.2041089700f,0.97894818f,0.2056104100f,0.97863392f,
	0.2071113800f,0.97831737f,0.2086118500f,0.97799851f,
	0.2101118400f,0.97767736f,0.2116113300f,0.9773539f,
	0.2131103200f,0.97702814f,0.2146088100f,0.97670009f,
	0.2161068000f,0.97636973f,0.2176042700f,0.97603708f,
	0.2191012400f,0.97570213f,0.2205976900f,0.97536489f,
	0.2220936200f,0.97502535f,0.2235890300f,0.97468351f,
	0.2250839100f,0.97433938f,0.2265782600f,0.97399296f,
	0.2280720800f,0.97364425f,0.2295653700f,0.97329325f,
	0.2310581100f,0.97293995f,0.2325503100f,0.97258437f,
	0.2340419600f,0.97222650f,0.2355330600f,0.97186634f,
	0.2370236100f,0.97150389f,0.2385135900f,0.97113916f,
	0.2400030200f,0.97077214f,0.2414918900f,0.97040284f,
	0.2429801800f,0.97003125f,0.2444679000f,0.96965739f,
	0.2459550500f,0.96928124f,0.2474416200f,0.96890280f,
	0.2489276100f,0.96852209f,0.2504130100f,0.96813910f,
	0.2518978200f,0.96775384f,0.2533820400f,0.96736629f,
	0.2548656600f,0.96697647f,0.2563486800f,0.96658437f,
	0.2578311000f,0.96619000f,0.2593129200f,0.96579336f,
	0.2607941200f,0.96539444f,0.2622747100f,0.96499325f,
	0.2637546800f,0.96458979f,0.2652340300f,0.96418406f,
	0.2667127600f,0.96377607f,0.2681908600f,0.9633658f,
	0.2696683300f,0.96295327f,0.2711451600f,0.96253847f,
	0.2726213600f,0.96212140f,0.2740969100f,0.96170208f,
	0.2755718200f,0.96128049f,0.2770460800f,0.96085663f,
	0.2785196900f,0.96043052f,0.2799926400f,0.96000215f,
	0.2814649400f,0.95957151f,0.2829365700f,0.95913862f,
	0.2844075400f,0.95870347f,0.2858778300f,0.95826607f,
	0.2873474600f,0.95782641f,0.2888164100f,0.9573845f,
	0.2902846800f,0.95694034f,0.2917522600f,0.95649392f,
	0.2932191600f,0.95604525f,0.2946853700f,0.95559433f,
	0.2961508900f,0.95514117f,0.2976157100f,0.95468575f,
	0.2990798300f,0.95422810f,0.3005432400f,0.95376819f,
	0.3020059500f,0.95330604f,0.3034679500f,0.95284165f,
	0.3049292300f,0.95237501f,0.3063898000f,0.95190614f,
	0.3078496400f,0.95143502f,0.3093087600f,0.95096167f,
	0.3107671500f,0.95048607f,0.3122248100f,0.95000825f,
	0.3136817400f,0.94952818f,0.3151379300f,0.94904588f,
	0.3165933800f,0.94856135f,0.3180480800f,0.94807459f,
	0.3195020300f,0.94758559f,0.3209552300f,0.94709437f,
	0.3224076800f,0.94660091f,0.3238593700f,0.94610523f,
	0.3253102900f,0.94560733f,0.3267604500f,0.94510719f,
	0.3282098400f,0.94460484f,0.3296584600f,0.94410026f,
	0.3311063100f,0.94359346f,0.3325533700f,0.94308444f,
	0.3339996500f,0.94257320f,0.3354451500f,0.94205974f,
	0.3368898500f,0.94154407f,0.3383337700f,0.94102618f,
	0.3397768800f,0.94050607f,0.3412192000f,0.93998375f,
	0.3426607200f,0.93945922f,0.3441014300f,0.93893248f,
	0.3455413200f,0.93840353f,0.3469804100f,0.93787238f,
	0.3484186800f,0.93733901f,0.3498561300f,0.93680344f,
	0.3512927600f,0.93626567f,0.3527285600f,0.93572569f,
	0.3541635300f,0.93518351f,0.3555976600f,0.93463913f,
	0.3570309600f,0.93409255f,0.3584634200f,0.93354377f,
	0.3598950400f,0.93299280f,0.3613258100f,0.93243963f,
	0.3627557200f,0.93188427f,0.3641847900f,0.93132671f,
	0.3656130000f,0.93076696f,0.3670403500f,0.93020502f,
	0.3684668300f,0.92964090f,0.3698924500f,0.92907458f,
	0.3713171900f,0.92850608f,0.3727410700f,0.92793539f,
	0.3741640600f,0.92736253f,0.3755861800f,0.92678747f,
	0.3770074100f,0.92621024f,0.3784277500f,0.92563083f,
	0.3798472100f,0.92504924f,0.3812657700f,0.92446547f,
	0.3826834300f,0.92387953f,0.3841002000f,0.92329142f,
	0.3855160500f,0.92270113f,0.3869310100f,0.92210867f,
	0.3883450500f,0.92151404f,0.3897581700f,0.92091724f,
	0.3911703800f,0.92031828f,0.3925816700f,0.91971715f,
	0.3939920400f,0.91911385f,0.3954014800f,0.91850839f,
	0.3968099900f,0.91790078f,0.3982175600f,0.91729100f,
	0.3996242000f,0.91667906f,0.4010299000f,0.91606497f,
	0.4024346500f,0.91544872f,0.4038384600f,0.91483031f,
	0.4052413100f,0.91420976f,0.4066432200f,0.91358705f,
	0.4080441600f,0.91296219f,0.4094441500f,0.91233518f,
	0.4108431700f,0.91170603f,0.4122412300f,0.91107473f,
	0.4136383100f,0.91044129f,0.4150344200f,0.90980571f,
	0.4164295600f,0.90916798f,0.4178237200f,0.90852812f,
	0.4192168900f,0.90788612f,0.4206090700f,0.90724198f,
	0.4220002700f,0.90659570f,0.4233904700f,0.90594730f,
	0.4247796800f,0.90529676f,0.4261678900f,0.90464409f,
	0.4275550900f,0.90398929f,0.4289412900f,0.90333237f,
	0.4303264800f,0.90267332f,0.4317106600f,0.90201214f,
	0.4330938200f,0.90134885f,0.4344759600f,0.90068343f,
	0.4358570800f,0.90001589f,0.4372371700f,0.89934624f,
	0.4386162400f,0.89867447f,0.4399942700f,0.89800058f,
	0.4413712700f,0.89732458f,0.4427472300f,0.89664647f,
	0.4441221400f,0.89596625f,0.4454960200f,0.89528392f,
	0.4468688400f,0.89459949f,0.4482406100f,0.89391295f,
	0.4496113300f,0.89322430f,0.4509809900f,0.89253356f,
	0.4523495900f,0.89184071f,0.4537171200f,0.89114576f,
	0.4550835900f,0.89044872f,0.4564489800f,0.88974959f,
	0.4578133000f,0.88904836f,0.4591765500f,0.88834503f,
	0.4605387100f,0.88763962f,0.4618997900f,0.88693212f,
	0.4632597800f,0.88622253f,0.4646186900f,0.88551086f,
	0.4659765000f,0.88479710f,0.4673332100f,0.88408126f,
	0.4686888200f,0.88336334f,0.4700433300f,0.88264334f,
	0.4713967400f,0.88192126f,0.4727490300f,0.88119711f,
	0.4741002100f,0.88047089f,0.4754502800f,0.87974259f,
	0.4767992300f,0.87901223f,0.4781470600f,0.87827979f,
	0.4794937600f,0.87754529f,0.4808393300f,0.87680872f,
	0.4821837700f,0.87607009f,0.4835270800f,0.87532940f,
	0.4848692500f,0.87458665f,0.4862102800f,0.87384184f,
	0.4875501600f,0.87309498f,0.4888889000f,0.87234606f,
	0.4902264800f,0.87159509f,0.4915629200f,0.87084206f,
	0.4928981900f,0.87008699f,0.4942323100f,0.86932987f,
	0.4955652600f,0.86857071f,0.4968970500f,0.86780950f,
	0.4982276700f,0.86704625f,0.4995571100f,0.86628095f,
	0.5008853800f,0.86551362f,0.5022124700f,0.86474426f,
	0.5035383800f,0.86397286f,0.5048631100f,0.86319942f,
	0.5061866500f,0.86242396f,0.5075089900f,0.86164646f,
	0.5088301400f,0.86086694f,0.5101501000f,0.86008539f,
	0.5114688500f,0.85930182f,0.5127864000f,0.85851622f,
	0.5141027400f,0.85772861f,0.5154178800f,0.85693898f,
	0.5167318000f,0.85614733f,0.5180445000f,0.85535366f,
	0.5193559900f,0.85455799f,0.5206662500f,0.85376030f,
	0.5219752900f,0.85296060f,0.5232831000f,0.85215890f,
	0.5245896800f,0.85135519f,0.5258950300f,0.85054948f,
	0.5271991300f,0.84974177f,0.5285020000f,0.84893206f,
	0.5298036200f,0.84812034f,0.5311040000f,0.84730664f,
	0.5324031300f,0.84649094f,0.5337010000f,0.84567325f,
	0.5349976200f,0.84485357f,0.5362929800f,0.84403190f,
	0.5375870800f,0.84320824f,0.5388799100f,0.84238260f,
	0.5401714700f,0.84155498f,0.5414617700f,0.84072537f,
	0.5427507800f,0.83989379f,0.5440385300f,0.83906024f,
	0.5453249900f,0.83822471f,0.5466101700f,0.83738720f,
	0.5478940600f,0.83654773f,0.5491766600f,0.83570628f,
	0.5504579700f,0.83486287f,0.5517379900f,0.83401750f,
	0.5530167100f,0.83317016f,0.5542941200f,0.83232087f,
	0.5555702300f,0.83146961f,0.5568450400f,0.83061640f,
	0.5581185300f,0.82976123f,0.5593907100f,0.82890411f,
	0.5606615800f,0.82804505f,0.5619311200f,0.82718403f,
	0.5631993400f,0.82632106f,0.5644662400f,0.82545615f,
	0.5657318100f,0.82458930f,0.5669960500f,0.82372051f,
	0.5682589500f,0.82284978f,0.5695205200f,0.82197712f,
	0.5707807500f,0.82110251f,0.5720396300f,0.82022598f,
	0.5732971700f,0.81934752f,0.5745533600f,0.81846713f,
	0.5758081900f,0.81758481f,0.5770616700f,0.81670057f,
	0.5783138000f,0.81581441f,0.5795645600f,0.81492633f,
	0.5808139600f,0.81403633f,0.5820619900f,0.81314441f,
	0.5833086500f,0.81225059f,0.5845539400f,0.81135485f,
	0.5857978600f,0.81045720f,0.5870403900f,0.80955764f,
	0.5882815500f,0.80865618f,0.5895213200f,0.80775282f,
	0.5907597000f,0.80684755f,0.5919966900f,0.80594039f,
	0.5932323000f,0.80503133f,0.5944665000f,0.80412038f,
	0.5956993000f,0.80320753f,0.5969307100f,0.80229280f,
	0.5981607100f,0.80137617f,0.5993893000f,0.80045766f,
	0.6006164800f,0.79953727f,0.6018422500f,0.79861499f,
	0.6030666000f,0.79769084f,0.6042895300f,0.79676481f,
	0.6055110400f,0.79583690f,0.6067311300f,0.79490713f,
	0.6079497800f,0.79397548f,0.6091670100f,0.79304196f,
	0.6103828100f,0.79210658f,0.6115971600f,0.79116933f,
	0.6128100800f,0.79023022f,0.6140215600f,0.78928925f,
	0.6152315900f,0.78834643f,0.6164401700f,0.78740175f,
	0.6176473100f,0.78645521f,0.6188529900f,0.78550683f,
	0.6200572100f,0.78455660f,0.6212599800f,0.78360452f,
	0.6224612800f,0.78265060f,0.6236611200f,0.78169483f,
	0.6248594900f,0.78073723f,0.6260563900f,0.77977779f,
	0.6272518200f,0.77881651f,0.6284457700f,0.77785340f,
	0.6296382400f,0.77688847f,0.6308292300f,0.77592170f,
	0.6320187400f,0.77495311f,0.6332067600f,0.77398269f,
	0.6343932800f,0.77301045f,0.6355783200f,0.77203640f,
	0.6367618600f,0.77106052f,0.6379439000f,0.77008284f,
	0.6391244400f,0.76910334f,0.6403034800f,0.76812203f,
	0.6414810100f,0.76713891f,0.6426570300f,0.76615399f,
	0.6438315400f,0.76516727f,0.6450045400f,0.76417874f,
	0.6461760100f,0.76318842f,0.6473459700f,0.76219630f,
	0.6485144000f,0.76120239f,0.6496813100f,0.76020668f,
	0.6508466800f,0.75920919f,0.6520105300f,0.75820991f,
	0.6531728400f,0.75720885f,0.6543336200f,0.75620600f,
	0.6554928500f,0.75520138f,0.6566505500f,0.75419498f,
	0.6578066900f,0.75318680f,0.6589612900f,0.75217685f,
	0.6601143400f,0.75116513f,0.6612658400f,0.75015165f,
	0.6624157800f,0.74913639f,0.6635641600f,0.74811938f,
	0.6647109800f,0.74710061f,0.6658562300f,0.74608007f,
	0.6669999200f,0.74505779f,0.6681420400f,0.74403374f,
	0.6692825900f,0.74300795f,0.6704215600f,0.74198041f,
	0.6715589500f,0.74095113f,0.6726947700f,0.73992010f,
	0.6738290000f,0.73888732f,0.6749616500f,0.73785281f,
	0.6760927000f,0.73681657f,0.6772221700f,0.73577859f,
	0.6783500400f,0.73473888f,0.6794763200f,0.73369744f,
	0.6806010000f,0.73265427f,0.6817240700f,0.73160938f,
	0.6828455500f,0.73056277f,0.6839654100f,0.72951444f,
	0.6850836700f,0.72846439f,0.6862003100f,0.72741263f,
	0.6873153400f,0.72635916f,0.6884287500f,0.72530397f,
	0.6895405400f,0.72424708f,0.6906507100f,0.72318849f,
	0.6917592600f,0.72212819f,0.6928661700f,0.72106620f,
	0.6939714600f,0.72000251f,0.6950751100f,0.71893712f,
	0.6961771300f,0.71787005f,0.6972775100f,0.71680128f,
	0.6983762500f,0.71573083f,0.6994733400f,0.71465869f,
	0.7005687900f,0.71358487f,0.7016625900f,0.71250937f,
	0.7027547400f,0.71143220f,0.7038452400f,0.71035335f,
	0.7049340800f,0.70927283f,0.7060212600f,0.70819064f,
	0.7071067800f,0.70710678f
};

static float fsincos_lookup1[1024] =
{
	0.00076699032f,0.99999971f,0.0023009692f,0.99999735f,
	0.00383494260f,0.99999265f,0.0053689070f,0.99998559f,
	0.00690285870f,0.99997617f,0.0084367942f,0.99996441f,
	0.00997070990f,0.99995029f,0.0115046020f,0.99993382f,
	0.01303846700f,0.99991500f,0.0145723020f,0.99989382f,
	0.01610610200f,0.99987029f,0.0176398640f,0.99984441f,
	0.01917358500f,0.99981617f,0.0207072610f,0.99978558f,
	0.02224088700f,0.99975264f,0.0237744620f,0.99971735f,
	0.02530798100f,0.99967970f,0.0268414400f,0.99963970f,
	0.02837483600f,0.99959735f,0.0299081650f,0.99955265f,
	0.03144142400f,0.99950560f,0.0329746080f,0.99945619f,
	0.03450771600f,0.99940443f,0.0360407420f,0.99935032f,
	0.03757368300f,0.99929386f,0.0391065350f,0.99923505f,
	0.04063929600f,0.99917388f,0.0421719610f,0.99911037f,
	0.04370452700f,0.99904450f,0.0452369900f,0.99897628f,
	0.04676934700f,0.99890572f,0.0483015930f,0.99883280f,
	0.04983372600f,0.99875753f,0.0513657420f,0.99867991f,
	0.05289763700f,0.99859994f,0.0544294070f,0.99851762f,
	0.05596104900f,0.99843295f,0.0574925600f,0.99834593f,
	0.05902393500f,0.99825657f,0.0605551710f,0.99816485f,
	0.06208626500f,0.99807079f,0.0636172130f,0.99797437f,
	0.06514801100f,0.99787561f,0.0666786560f,0.99777450f,
	0.06820914400f,0.99767104f,0.0697394710f,0.99756524f,
	0.07126963400f,0.99745709f,0.0727996300f,0.99734659f,
	0.07432945400f,0.99723374f,0.0758591030f,0.99711855f,
	0.07738857400f,0.99700101f,0.0789178630f,0.99688112f,
	0.08044696600f,0.99675889f,0.0819758800f,0.99663431f,
	0.08350460100f,0.99650739f,0.0850331250f,0.99637812f,
	0.08656144900f,0.99624651f,0.0880895700f,0.99611256f,
	0.08961748300f,0.99597626f,0.0911451850f,0.99583761f,
	0.09267267300f,0.99569663f,0.0941999430f,0.99555330f,
	0.09572699100f,0.99540763f,0.0972538140f,0.99525961f,
	0.09878040900f,0.99510926f,0.1003067700f,0.99495656f,
	0.10183290000f,0.99480152f,0.1033587800f,0.99464414f,
	0.10488442000f,0.99448442f,0.1064098200f,0.99432236f,
	0.10793497000f,0.99415796f,0.1094598600f,0.99399122f,
	0.11098449000f,0.99382214f,0.1125088600f,0.99365072f,
	0.11403297000f,0.99347697f,0.1155568100f,0.99330087f,
	0.11708038000f,0.99312244f,0.1186036700f,0.99294167f,
	0.12012669000f,0.99275857f,0.1216494200f,0.99257313f,
	0.12317186000f,0.99238535f,0.1246940200f,0.99219524f,
	0.12621588000f,0.99200280f,0.1277374400f,0.99180802f,
	0.12925870000f,0.99161091f,0.1307796600f,0.99141146f,
	0.13230032000f,0.99120968f,0.1338206600f,0.99100557f,
	0.13534068000f,0.99079912f,0.1368603900f,0.99059035f,
	0.13837977000f,0.99037924f,0.1398988300f,0.99016580f,
	0.14141756000f,0.98995004f,0.1429359600f,0.98973194f,
	0.14445402000f,0.98951151f,0.1459717400f,0.98928876f,
	0.14748912000f,0.98906368f,0.1490061500f,0.98883627f,
	0.15052283000f,0.98860653f,0.1520391600f,0.98837447f,
	0.15355512000f,0.98814008f,0.1550707300f,0.98790337f,
	0.15658597000f,0.98766433f,0.1581008500f,0.98742297f,
	0.15961535000f,0.98717929f,0.1611294700f,0.98693328f,
	0.16264322000f,0.98668495f,0.1641565800f,0.98643429f,
	0.16566956000f,0.98618132f,0.1671821500f,0.98592603f,
	0.16869434000f,0.98566841f,0.1702061400f,0.98540848f,
	0.17171754000f,0.98514623f,0.1732285300f,0.98488166f,
	0.17473911000f,0.98461477f,0.1762492900f,0.98434556f,
	0.17775905000f,0.98407404f,0.1792683900f,0.98380021f,
	0.18077731000f,0.98352405f,0.1822858000f,0.98324559f,
	0.18379387000f,0.98296481f,0.1853015000f,0.98268172f,
	0.18680870000f,0.98239631f,0.1883154500f,0.98210859f,
	0.18982177000f,0.98181857f,0.1913276300f,0.98152623f,
	0.19283305000f,0.98123158f,0.1943380100f,0.98093462f,
	0.19584252000f,0.98063536f,0.1973465600f,0.98033379f,
	0.19885014000f,0.98002991f,0.2003532600f,0.97972372f,
	0.20185590000f,0.97941523f,0.2033580600f,0.97910444f,
	0.20485975000f,0.97879134f,0.2063609600f,0.97847594f,
	0.20786168000f,0.97815823f,0.2093619100f,0.97783822f,
	0.21086164000f,0.97751592f,0.2123608900f,0.97719131f,
	0.21385963000f,0.97686440f,0.2153578700f,0.97653520f,
	0.21685560000f,0.97620369f,0.2183528200f,0.97586989f,
	0.21984953000f,0.97553379f,0.2213457200f,0.97519540f,
	0.22284139000f,0.97485471f,0.2243365400f,0.97451173f,
	0.22583115000f,0.97416646f,0.2273252400f,0.97381889f,
	0.22881879000f,0.97346903f,0.2303118000f,0.97311689f,
	0.23180428000f,0.97276245f,0.2332962000f,0.97240572f,
	0.23478758000f,0.97204670f,0.2362784000f,0.97168540f,
	0.23776867000f,0.97132181f,0.2392583800f,0.97095594f,
	0.24074752000f,0.97058778f,0.2422361000f,0.97021733f,
	0.24372411000f,0.96984460f,0.2452115500f,0.96946960f,
	0.24669841000f,0.96909231f,0.2481846900f,0.96871273f,
	0.24967038000f,0.96833088f,0.2511554900f,0.96794676f,
	0.25264000000f,0.96756035f,0.2541239200f,0.96717167f,
	0.25560725000f,0.96678071f,0.2570899700f,0.96638747f,
	0.25857208000f,0.96599197f,0.2600535900f,0.96559418f,
	0.26153449000f,0.96519413f,0.2630147700f,0.96479181f,
	0.26449443000f,0.96438721f,0.2659734700f,0.96398035f,
	0.26745189000f,0.96357122f,0.2689296700f,0.96315982f,
	0.27040682000f,0.96274615f,0.2718833400f,0.96233022f,
	0.27335921000f,0.96191202f,0.2748344500f,0.96149156f,
	0.27630903000f,0.96106884f,0.2777829700f,0.96064386f,
	0.27925625000f,0.96021662f,0.2807288700f,0.95978711f,
	0.28220084000f,0.95935535f,0.2836721400f,0.95892133f,
	0.28514277000f,0.95848506f,0.2866127300f,0.95804652f,
	0.28808202000f,0.95760574f,0.2895506300f,0.95716270f,
	0.29101856000f,0.95671741f,0.2924858000f,0.95626987f,
	0.29395235000f,0.95582007f,0.2954182200f,0.95536803f,
	0.29688339000f,0.95491374f,0.2983478500f,0.95445721f,
	0.29981162000f,0.95399842f,0.3012746800f,0.95353740f,
	0.30273704000f,0.95307412f,0.3041986800f,0.95260861f,
	0.30565960000f,0.95214085f,0.3071198100f,0.95167086f,
	0.30857929000f,0.95119862f,0.3100380500f,0.95072415f,
	0.31149607000f,0.95024744f,0.3129533700f,0.94976849f,
	0.31440993000f,0.94928731f,0.3158657500f,0.94880389f,
	0.31732082000f,0.94831825f,0.3187751500f,0.94783037f,
	0.32022873000f,0.94734026f,0.3216815500f,0.94684792f,
	0.32313362000f,0.94635335f,0.3245849200f,0.94585656f,
	0.32603547000f,0.94535754f,0.3274852400f,0.94485629f,
	0.32893425000f,0.94435283f,0.3303824800f,0.94384714f,
	0.33182994000f,0.94333923f,0.3332766100f,0.94282909f,
	0.33472250000f,0.94231675f,0.3361676000f,0.94180218f,
	0.33761191000f,0.94128540f,0.3390554300f,0.94076640f,
	0.34049814000f,0.94024519f,0.3419400600f,0.93972176f,
	0.34338117000f,0.93919613f,0.3448214800f,0.93866828f,
	0.34626097000f,0.93813823f,0.3476996500f,0.93760597f,
	0.34913751000f,0.93707150f,0.3505745500f,0.93653483f,
	0.35201076000f,0.93599595f,0.3534461400f,0.93545487f,
	0.35488070000f,0.93491159f,0.3563144200f,0.93436611f,
	0.35774730000f,0.93381844f,0.3591793300f,0.93326856f,
	0.36061053000f,0.93271649f,0.3620408700f,0.93216222f,
	0.36347036000f,0.93160576f,0.3648990000f,0.93104711f,
	0.36632678000f,0.93048627f,0.3677537000f,0.92992323f,
	0.36917975000f,0.92935801f,0.3706049300f,0.92879060f,
	0.37202924000f,0.92822101f,0.3734526700f,0.92764923f,
	0.37487523000f,0.92707527f,0.3762969100f,0.92649913f,
	0.37771769000f,0.92592081f,0.3791375900f,0.92534031f,
	0.38055660000f,0.92475763f,0.3819747100f,0.92417278f,
	0.38339193000f,0.92358575f,0.3848082400f,0.92299654f,
	0.38622364000f,0.92240517f,0.3876381400f,0.92181163f,
	0.38905172000f,0.92121591f,0.3904643900f,0.92061803f,
	0.39187614000f,0.92001798f,0.3932869700f,0.91941577f,
	0.39469688000f,0.91881139f,0.3961058500f,0.91820486f,
	0.39751389000f,0.91759616f,0.3989210000f,0.91698530f,
	0.40032717000f,0.91637228f,0.4017323900f,0.91575711f,
	0.40313667000f,0.91513978f,0.4045400000f,0.91452030f,
	0.40594238000f,0.91389867f,0.4073438100f,0.91327489f,
	0.40874428000f,0.91264896f,0.4101437800f,0.91202088f,
	0.41154232000f,0.91139065f,0.4129398900f,0.91075828f,
	0.41433649000f,0.91012377f,0.4157321100f,0.90948711f,
	0.41712676000f,0.90884832f,0.4185204300f,0.90820738f,
	0.41991310000f,0.90756431f,0.4213048000f,0.90691911f,
	0.42269550000f,0.90627177f,0.4240852000f,0.90562229f,
	0.42547391000f,0.90497069f,0.4268616200f,0.90431696f,
	0.42824832000f,0.90366110f,0.4296340100f,0.90300311f,
	0.43101870000f,0.90234300f,0.4324023700f,0.90168076f,
	0.43378502000f,0.90101640f,0.4351666500f,0.90034993f,
	0.43654726000f,0.89968133f,0.4379268300f,0.89901062f,
	0.43930538000f,0.89833779f,0.4406829000f,0.89766284f,
	0.44205938000f,0.89698579f,0.4434348200f,0.89630662f,
	0.44480921000f,0.89562535f,0.4461825600f,0.89494197f,
	0.44755486000f,0.89425648f,0.4489261000f,0.89356889f,
	0.45029629000f,0.89287919f,0.4516654200f,0.89218739f,
	0.45303349000f,0.89149350f,0.4544004900f,0.89079751f,
	0.45576642000f,0.89009942f,0.4571312800f,0.88939923f,
	0.45849506000f,0.88869696f,0.4598577600f,0.88799259f,
	0.46121939000f,0.88728613f,0.4625799200f,0.88657759f,
	0.46393937000f,0.88586695f,0.4652977300f,0.88515424f,
	0.46665499000f,0.88443944f,0.4680111500f,0.88372256f,
	0.46936622000f,0.88300360f,0.4707201700f,0.88228256f,
	0.47207302000f,0.88155945f,0.4734247600f,0.88083426f,
	0.47477539000f,0.88010700f,0.4761249000f,0.87937767f,
	0.47747328000f,0.87864627f,0.4788205500f,0.87791280f,
	0.48016669000f,0.87717727f,0.4815116900f,0.87643967f,
	0.48285557000f,0.87570001f,0.4841983100f,0.87495829f,
	0.48553990000f,0.87421451f,0.4868803600f,0.87346867f,
	0.48821967000f,0.87272078f,0.4895578300f,0.87197083f,
	0.49089484000f,0.87121883f,0.4922307000f,0.87046478f,
	0.49356540000f,0.86970869f,0.4948989300f,0.86895054f,
	0.49623130000f,0.86819036f,0.4975625000f,0.86742813f,
	0.49889254000f,0.86666385f,0.5002213900f,0.86589754f,
	0.50154908000f,0.86512920f,0.5028755800f,0.86435881f,
	0.50420089000f,0.86358639f,0.5055250300f,0.86281194f,
	0.50684797000f,0.86203546f,0.5081697200f,0.86125695f,
	0.50949027000f,0.86047642f,0.5108096200f,0.85969386f,
	0.51212778000f,0.85890927f,0.5134447200f,0.85812267f,
	0.51476046000f,0.85733405f,0.5160749900f,0.85654340f,
	0.51738830000f,0.85575075f,0.5187004000f,0.85495608f,
	0.52001128000f,0.85415940f,0.5213209300f,0.85336070f,
	0.52262935000f,0.85256000f,0.5239365500f,0.85175730f,
	0.52524251000f,0.85095259f,0.5265472400f,0.85014587f,
	0.52785072000f,0.84933716f,0.5291529700f,0.84852645f,
	0.53045397000f,0.84771374f,0.5317537200f,0.84689904f,
	0.53305222000f,0.84608234f,0.5343494700f,0.84526365f,
	0.53564546000f,0.84444298f,0.5369401900f,0.84362032f,
	0.53823365000f,0.84279567f,0.5395258500f,0.84196904f,
	0.54081678000f,0.84114042f,0.5421064300f,0.84030983f,
	0.54339482000f,0.83947726f,0.5446819200f,0.83864272f,
	0.54596774000f,0.83780620f,0.5472522700f,0.83696771f,
	0.54853552000f,0.83612725f,0.5498174800f,0.83528483f,
	0.55109814000f,0.83444043f,0.5523775100f,0.83359408f,
	0.55365558000f,0.83274576f,0.5549323400f,0.83189548f,
	0.55620780000f,0.83104325f,0.5574819500f,0.83018906f,
	0.55875479000f,0.82933292f,0.5600263100f,0.82847482f,
	0.56129651000f,0.82761478f,0.5625654000f,0.82675279f,
	0.56383296000f,0.82588885f,0.5650991900f,0.82502297f,
	0.56636410000f,0.82415515f,0.5676276700f,0.82328539f,
	0.56888990000f,0.82241369f,0.5701508000f,0.82154006f,
	0.57141036000f,0.82066449f,0.5726685700f,0.81978699f,
	0.57392543000f,0.81890757f,0.5751809400f,0.81802621f,
	0.57643510000f,0.81714293f,0.5776879000f,0.81625773f,
	0.57893935000f,0.81537061f,0.5801894300f,0.81448157f,
	0.58143815000f,0.81359061f,0.5826854900f,0.81269774f,
	0.58393147000f,0.81180296f,0.5851760700f,0.81090626f,
	0.58641930000f,0.81000766f,0.5876611400f,0.80910715f,
	0.58890161000f,0.80820474f,0.5901406800f,0.80730042f,
	0.59137837000f,0.80639421f,0.5926146700f,0.80548610f,
	0.59384957000f,0.80457609f,0.5950830800f,0.80366419f,
	0.59631518000f,0.80275040f,0.5975458800f,0.80183472f,
	0.59877518000f,0.80091715f,0.6000030700f,0.79999770f,
	0.60122954000f,0.79907637f,0.6024546000f,0.79815315f,
	0.60367824000f,0.79722806f,0.6049004600f,0.79630109f,
	0.60612126000f,0.79537225f,0.6073406300f,0.79444154f,
	0.60855858000f,0.79350895f,0.6097750900f,0.79257450f,
	0.61099016000f,0.79163819f,0.6122038000f,0.79070001f,
	0.61341600000f,0.78975997f,0.6146267600f,0.78881807f,
	0.61583606000f,0.78787432f,0.6170439200f,0.78692871f,
	0.61825033000f,0.78598125f,0.6194552800f,0.78503194f,
	0.62065878000f,0.78408079f,0.6218608100f,0.78312779f,
	0.62306138000f,0.78217294f,0.6242604900f,0.78121626f,
	0.62545812000f,0.78025774f,0.6266542900f,0.77929738f,
	0.62784898000f,0.77833519f,0.6290421900f,0.77737116f,
	0.63023392000f,0.77640531f,0.6314241700f,0.77543763f,
	0.63261293000f,0.77446813f,0.6338002100f,0.77349680f,
	0.63498599000f,0.77252365f,0.6361702800f,0.77154869f,
	0.63735307000f,0.77057191f,0.6385343600f,0.76959331f,
	0.63971415000f,0.76861291f,0.6408924400f,0.76763070f,
	0.64206921000f,0.76664668f,0.6432444800f,0.76566085f,
	0.64441823000f,0.76467323f,0.6455904600f,0.76368380f,
	0.64676118000f,0.76269258f,0.6479303800f,0.76169957f,
	0.64909805000f,0.76070476f,0.6502641900f,0.75970816f,
	0.65142880000f,0.75870977f,0.6525918800f,0.75770960f,
	0.65375342000f,0.75670765f,0.6549134300f,0.75570391f,
	0.65607189000f,0.75469840f,0.6572288100f,0.75369111f,
	0.65838419000f,0.75268205f,0.6595380100f,0.75167121f,
	0.66069028000f,0.75065861f,0.6618410000f,0.74964424f,
	0.66299016000f,0.74862811f,0.6641377600f,0.74761021f,
	0.66528380000f,0.74659056f,0.6664282700f,0.74556915f,
	0.66757118000f,0.74454598f,0.6687125100f,0.74352107f,
	0.66985227000f,0.74249440f,0.6709904500f,0.74146599f,
	0.67212706000f,0.74043583f,0.6732620800f,0.73940393f,
	0.67439552000f,0.73837029f,0.6755273700f,0.73733491f,
	0.67665764000f,0.73629780f,0.6777863100f,0.73525895f,
	0.67891338000f,0.73421837f,0.6800388600f,0.73317607f,
	0.68116274000f,0.73213204f,0.6822850100f,0.73108629f,
	0.68340568000f,0.73003882f,0.6845247400f,0.72898963f,
	0.68564219000f,0.72793872f,0.6867580300f,0.72688611f,
	0.68787225000f,0.72583178f,0.6889848500f,0.72477574f,
	0.69009583000f,0.72371800f,0.6912051900f,0.72265855f,
	0.69231292000f,0.72159741f,0.6934190200f,0.72053457f,
	0.69452349000f,0.71947003f,0.6956263300f,0.71840380f,
	0.69672753000f,0.71733587f,0.6978270900f,0.71626626f,
	0.69892500000f,0.71519497f,0.7000212800f,0.71412199f,
	0.70111590000f,0.71304733f,0.7022088800f,0.71197099f,
	0.70330020000f,0.71089298f,0.7043898700f,0.70981330f,
	0.70547788000f,0.70873194f,0.7065642300f,0.70764892f
};
